/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.routing;

import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class RoutingAppenderKeyLookupEvaluationTest {
    private static final String CONFIG = "log4j-routing-lookup.xml";
    private static final String KEY = "user";
    private ListAppender app;
    @Rule
    public final LoggerContextRule loggerContextRule = new LoggerContextRule("log4j-routing-lookup.xml");

    @Before
    public void setUp() throws Exception {
        ThreadContext.remove((String)KEY);
        this.app = this.loggerContextRule.getListAppender("List");
    }

    @After
    public void tearDown() throws Exception {
        this.app.clear();
        this.loggerContextRule.getLoggerContext().stop();
        ThreadContext.remove((String)KEY);
    }

    @Test
    public void testRoutingNoUser() {
        Logger logger = this.loggerContextRule.getLogger(this.getClass());
        logger.warn("no user");
        String message = this.app.getMessages().get(0);
        Assert.assertEquals((Object)"WARN ${ctx:user} no user", (Object)message);
    }

    @Test
    public void testRoutingDoesNotMatchRoute() {
        Logger logger = this.loggerContextRule.getLogger(this.getClass());
        ThreadContext.put((String)KEY, (String)"noRouteExists");
        logger.warn("unmatched user");
        Assert.assertTrue((boolean)this.app.getMessages().isEmpty());
    }

    @Test
    public void testRoutingContainsLookup() {
        Logger logger = this.loggerContextRule.getLogger(this.getClass());
        ThreadContext.put((String)KEY, (String)"${java:version}");
        logger.warn("naughty user");
        String message = this.app.getMessages().get(0);
        Assert.assertEquals((Object)"WARN ${java:version} naughty user", (Object)message);
    }

    @Test
    public void testRoutingMatchesEscapedLookup() {
        Logger logger = this.loggerContextRule.getLogger(this.getClass());
        ThreadContext.put((String)KEY, (String)"${upper:name}");
        logger.warn("naughty user");
        String message = this.app.getMessages().get(0);
        Assert.assertEquals((Object)"WARN ${upper:name} naughty user", (Object)message);
    }

    @Test
    public void testRoutesThemselvesNotEvaluated() {
        Logger logger = this.loggerContextRule.getLogger(this.getClass());
        ThreadContext.put((String)KEY, (String)"NAME");
        logger.warn("unmatched user");
        Assert.assertTrue((boolean)this.app.getMessages().isEmpty());
    }
}

