/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import org.apache.logging.log4j.core.appender.rolling.action.CountingCondition;
import org.apache.logging.log4j.core.appender.rolling.action.DummyFileAttributes;
import org.apache.logging.log4j.core.appender.rolling.action.Duration;
import org.apache.logging.log4j.core.appender.rolling.action.IfLastModified;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.junit.Assert;
import org.junit.Test;

public class IfLastModifiedTest {
    @Test
    public void testGetDurationReturnsConstructorValue() {
        IfLastModified filter = IfLastModified.createAgeCondition((Duration)Duration.parse((CharSequence)"P7D"), (PathCondition[])new PathCondition[0]);
        Assert.assertEquals((long)0L, (long)filter.getAge().compareTo(Duration.parse((CharSequence)"P7D")));
    }

    @Test
    public void testAcceptsIfFileAgeEqualToDuration() {
        IfLastModified filter = IfLastModified.createAgeCondition((Duration)Duration.parse((CharSequence)"PT33S"), (PathCondition[])new PathCondition[0]);
        DummyFileAttributes attrs = new DummyFileAttributes();
        long age = 33000L;
        attrs.lastModified = FileTime.fromMillis(System.currentTimeMillis() - 33000L);
        Assert.assertTrue((boolean)filter.accept(null, null, (BasicFileAttributes)attrs));
    }

    @Test
    public void testAcceptsIfFileAgeExceedsDuration() {
        IfLastModified filter = IfLastModified.createAgeCondition((Duration)Duration.parse((CharSequence)"PT33S"), (PathCondition[])new PathCondition[0]);
        DummyFileAttributes attrs = new DummyFileAttributes();
        long age = 33005L;
        attrs.lastModified = FileTime.fromMillis(System.currentTimeMillis() - 33005L);
        Assert.assertTrue((boolean)filter.accept(null, null, (BasicFileAttributes)attrs));
    }

    @Test
    public void testDoesNotAcceptIfFileAgeLessThanDuration() {
        IfLastModified filter = IfLastModified.createAgeCondition((Duration)Duration.parse((CharSequence)"PT33S"), (PathCondition[])new PathCondition[0]);
        DummyFileAttributes attrs = new DummyFileAttributes();
        long age = 32995L;
        attrs.lastModified = FileTime.fromMillis(System.currentTimeMillis() - 32995L);
        Assert.assertFalse((boolean)filter.accept(null, null, (BasicFileAttributes)attrs));
    }

    @Test
    public void testAcceptCallsNestedConditionsOnlyIfPathAccepted() {
        CountingCondition counter = new CountingCondition(true);
        IfLastModified filter = IfLastModified.createAgeCondition((Duration)Duration.parse((CharSequence)"PT33S"), (PathCondition[])new PathCondition[]{counter});
        DummyFileAttributes attrs = new DummyFileAttributes();
        long oldEnough = 33005L;
        attrs.lastModified = FileTime.fromMillis(System.currentTimeMillis() - 33005L);
        Assert.assertTrue((boolean)filter.accept(null, null, (BasicFileAttributes)attrs));
        Assert.assertEquals((long)1L, (long)counter.getAcceptCount());
        Assert.assertTrue((boolean)filter.accept(null, null, (BasicFileAttributes)attrs));
        Assert.assertEquals((long)2L, (long)counter.getAcceptCount());
        Assert.assertTrue((boolean)filter.accept(null, null, (BasicFileAttributes)attrs));
        Assert.assertEquals((long)3L, (long)counter.getAcceptCount());
        long tooYoung = 32995L;
        attrs.lastModified = FileTime.fromMillis(System.currentTimeMillis() - 32995L);
        Assert.assertFalse((boolean)filter.accept(null, null, (BasicFileAttributes)attrs));
        Assert.assertEquals((long)3L, (long)counter.getAcceptCount());
        Assert.assertFalse((boolean)filter.accept(null, null, (BasicFileAttributes)attrs));
        Assert.assertEquals((long)3L, (long)counter.getAcceptCount());
        Assert.assertFalse((boolean)filter.accept(null, null, (BasicFileAttributes)attrs));
        Assert.assertEquals((long)3L, (long)counter.getAcceptCount());
    }

    @Test
    public void testBeforeTreeWalk() {
        CountingCondition counter = new CountingCondition(true);
        IfLastModified filter = IfLastModified.createAgeCondition((Duration)Duration.parse((CharSequence)"PT33S"), (PathCondition[])new PathCondition[]{counter, counter, counter});
        filter.beforeFileTreeWalk();
        Assert.assertEquals((long)3L, (long)counter.getBeforeFileTreeWalkCount());
    }
}

