/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;
import org.apache.logging.log4j.junit.StatusLoggerRule;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusLogger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class AbstractActionTest {
    @Rule
    public StatusLoggerRule statusLogger = new StatusLoggerRule(Level.WARN);

    @Test
    public void testExceptionsAreLoggedToStatusLogger() {
        StatusLogger statusLogger = StatusLogger.getLogger();
        statusLogger.clear();
        new TestAction().run();
        List statusDataList = statusLogger.getStatusData();
        Assert.assertEquals((long)1L, (long)statusDataList.size());
        StatusData statusData = (StatusData)statusDataList.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)statusData.getLevel());
        String formattedMessage = statusData.getFormattedStatus();
        String expected = String.format("Exception reported by action 'class org.apache.logging.log4j.core.appender.rolling.action.AbstractActionTest$TestAction' java.io.IOException: failed%n\tat org.apache.logging.log4j.core.appender.rolling.action.AbstractActionTest$TestAction.execute(AbstractActionTest.java:", new Object[0]);
        Assert.assertTrue((boolean)formattedMessage.contains(expected));
    }

    @Test
    public void testRuntimeExceptionsAreLoggedToStatusLogger() {
        StatusLogger statusLogger = StatusLogger.getLogger();
        statusLogger.clear();
        new AbstractAction(){

            public boolean execute() {
                throw new IllegalStateException();
            }
        }.run();
        List statusDataList = statusLogger.getStatusData();
        Assert.assertEquals((long)1L, (long)statusDataList.size());
        StatusData statusData = (StatusData)statusDataList.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)statusData.getLevel());
        String formattedMessage = statusData.getFormattedStatus();
        Assert.assertTrue((boolean)formattedMessage.contains("Exception reported by action"));
    }

    @Test
    public void testErrorsAreLoggedToStatusLogger() {
        StatusLogger statusLogger = StatusLogger.getLogger();
        statusLogger.clear();
        new AbstractAction(){

            public boolean execute() {
                throw new AssertionError();
            }
        }.run();
        List statusDataList = statusLogger.getStatusData();
        Assert.assertEquals((long)1L, (long)statusDataList.size());
        StatusData statusData = (StatusData)statusDataList.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)statusData.getLevel());
        String formattedMessage = statusData.getFormattedStatus();
        Assert.assertTrue((boolean)formattedMessage.contains("Exception reported by action"));
    }

    private static final class TestAction
    extends AbstractAction {
        private TestAction() {
        }

        public boolean execute() throws IOException {
            throw new IOException("failed");
        }
    }
}

