/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.junit.CleanFolders;
import org.apache.logging.log4j.status.StatusLogger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class RollingAppenderUncompressedTest {
    private static final String CONFIG = "log4j-rolling4.xml";
    private static final String DIR = "target/rolling4";
    private final Logger logger = LogManager.getLogger((String)RollingAppenderUncompressedTest.class.getName());
    @ClassRule
    public static CleanFolders rule = new CleanFolders("log4j-rolling4.xml");

    @BeforeClass
    public static void setupClass() {
        System.setProperty("log4j.configurationFile", CONFIG);
    }

    @AfterClass
    public static void cleanupClass() {
        System.clearProperty("log4j.configurationFile");
        LoggerContext ctx = LoggerContext.getContext();
        ctx.reconfigure();
        StatusLogger.getLogger().reset();
    }

    @Test
    public void testAppender() throws Exception {
        for (int i = 0; i < 100; ++i) {
            this.logger.debug("This is test message number " + i);
        }
        File dir = new File(DIR);
        Assert.assertTrue((String)"Directory not created", (dir.exists() && dir.listFiles().length > 0 ? 1 : 0) != 0);
        File[] files = dir.listFiles();
        Assert.assertNotNull((Object)files);
        boolean found = false;
        for (File file : files) {
            String name = file.getName();
            if (!name.startsWith("test1") || !name.endsWith(".log")) continue;
            found = true;
            break;
        }
        Assert.assertTrue((String)"No archived files found", (boolean)found);
    }
}

