/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.rolling.RollingAppenderDirectWriteTest;
import org.apache.logging.log4j.hamcrest.Descriptors;
import org.apache.logging.log4j.hamcrest.FileMatchers;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingAppenderDirectWriteTempCompressedFilePatternTest {
    private static final String CONFIG = "log4j-rolling-direct-tmp-compress-folder.xml";
    private static final String DIR = "target/rolling-direct";
    public static LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-direct-tmp-compress-folder.xml");
    @Rule
    public RuleChain chain = loggerContextRule.withCleanFoldersRule("target/rolling-direct");
    private Logger logger;

    @Before
    public void setUp() throws Exception {
        Assume.assumeTrue((!SystemUtils.IS_OS_MAC_OSX ? 1 : 0) != 0);
        this.logger = loggerContextRule.getLogger(RollingAppenderDirectWriteTest.class.getName());
    }

    @Test
    public void testAppender() throws Exception {
        File dir = new File(DIR);
        dir.mkdirs();
        try (WatchService watcher = FileSystems.getDefault().newWatchService();){
            WatchKey key = dir.toPath().register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
            for (int i = 0; i < 100; ++i) {
                this.logger.debug("This is test message number " + i);
            }
            Thread.sleep(50L);
            Assert.assertTrue((String)"Directory not created", (dir.exists() && dir.listFiles().length > 0 ? 1 : 0) != 0);
            File[] files = dir.listFiles();
            Assert.assertNotNull((Object)files);
            Assert.assertThat((Object)files, (Matcher)Matchers.hasItemInArray(Descriptors.that(FileMatchers.hasName(Descriptors.that(Matchers.endsWith((String)".gz"))))));
            int temporaryFilesCreated = 0;
            int compressedFiles = 0;
            key = watcher.take();
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent<?> ev = event;
                Path filename = (Path)ev.context();
                if (filename.toString().endsWith(".tmp")) {
                    ++temporaryFilesCreated;
                }
                if (!filename.toString().endsWith(".gz")) continue;
                ++compressedFiles;
            }
            Assert.assertTrue((String)"No temporary file created during compression", (temporaryFilesCreated > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Temporarys file created not equals to compressed files", (compressedFiles == temporaryFilesCreated ? 1 : 0) != 0);
        }
    }
}

