/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.util.List;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.util.Clock;
import org.apache.logging.log4j.core.util.ClockFactoryTest;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.message.TimestampMessage;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class TimestampMessageTest {
    private ListAppender app;
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j2-744.xml");

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j.Clock", PoisonClock.class.getName());
    }

    @Before
    public void setUp() throws Exception {
        this.app = context.getListAppender("List").clear();
    }

    @AfterClass
    public static void afterClass() throws IllegalAccessException {
        System.setProperty("Log4jContextSelector", "");
        ClockFactoryTest.resetClocks();
    }

    @Test
    public void testTimestampMessage() {
        Logger log = context.getLogger("TimestampMessageTest");
        log.info((Message)new TimeMsg("Message with embedded timestamp", 123456789000L));
        List<String> msgs = this.app.getMessages();
        Assert.assertNotNull(msgs);
        Assert.assertEquals((long)1L, (long)msgs.size());
        String NL = System.lineSeparator();
        Assert.assertEquals((Object)("123456789000 Message with embedded timestamp" + NL), (Object)msgs.get(0));
    }

    static class TimeMsg
    extends SimpleMessage
    implements TimestampMessage {
        private static final long serialVersionUID = 1L;
        private final long timestamp;

        public TimeMsg(String msg, long timestamp) {
            super(msg);
            this.timestamp = timestamp;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    public static class PoisonClock
    implements Clock {
        public long currentTimeMillis() {
            throw new RuntimeException("This should not have been called");
        }
    }
}

