/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.util.List;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class PatternResolverDoesNotEvaluateThreadContextTest {
    private static final String CONFIG = "log4j2-pattern-layout-with-context.xml";
    private static final String PARAMETER = "user";
    private ListAppender listAppender;
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j2-pattern-layout-with-context.xml");

    @Before
    public void before() {
        this.listAppender = context.getRequiredAppender("list", ListAppender.class);
        this.listAppender.clear();
    }

    @Test
    public void testNoUserSet() {
        Logger logger = context.getLogger(this.getClass());
        logger.info(MarkerManager.getMarker((String)"This is a test"), "msg");
        List<String> messages = this.listAppender.getMessages();
        Assert.assertTrue((String)"No messages returned", (messages != null && messages.size() > 0 ? 1 : 0) != 0);
        String message = messages.get(0);
        Assert.assertEquals((Object)"INFO org.apache.logging.log4j.core.PatternResolverDoesNotEvaluateThreadContextTest ${ctx:user} This is a test", (Object)message);
    }

    @Test
    public void testMessageIsNotLookedUp() {
        Logger logger = context.getLogger(this.getClass());
        logger.info(MarkerManager.getMarker((String)"This is a ${upper:test}"), "msg");
        List<String> messages = this.listAppender.getMessages();
        Assert.assertTrue((String)"No messages returned", (messages != null && messages.size() > 0 ? 1 : 0) != 0);
        String message = messages.get(0);
        Assert.assertEquals((Object)"INFO org.apache.logging.log4j.core.PatternResolverDoesNotEvaluateThreadContextTest ${ctx:user} This is a ${upper:test}", (Object)message);
    }

    @Test
    public void testUser() {
        Logger logger = context.getLogger(this.getClass());
        ThreadContext.put((String)PARAMETER, (String)"123");
        try {
            logger.info(MarkerManager.getMarker((String)"This is a test"), "msg");
        }
        finally {
            ThreadContext.remove((String)PARAMETER);
        }
        List<String> messages = this.listAppender.getMessages();
        Assert.assertTrue((String)"No messages returned", (messages != null && messages.size() > 0 ? 1 : 0) != 0);
        String message = messages.get(0);
        Assert.assertEquals((Object)"INFO org.apache.logging.log4j.core.PatternResolverDoesNotEvaluateThreadContextTest 123 This is a test", (Object)message);
    }

    @Test
    public void testUserIsLookup() {
        Logger logger = context.getLogger(this.getClass());
        ThreadContext.put((String)PARAMETER, (String)"${java:version}");
        try {
            logger.info(MarkerManager.getMarker((String)"This is a test"), "msg");
        }
        finally {
            ThreadContext.remove((String)PARAMETER);
        }
        List<String> messages = this.listAppender.getMessages();
        Assert.assertTrue((String)"No messages returned", (messages != null && messages.size() > 0 ? 1 : 0) != 0);
        String message = messages.get(0);
        Assert.assertEquals((Object)"INFO org.apache.logging.log4j.core.PatternResolverDoesNotEvaluateThreadContextTest ${java:version} This is a test", (Object)message);
    }

    @Test
    public void testUserHasLookup() {
        Logger logger = context.getLogger(this.getClass());
        ThreadContext.put((String)PARAMETER, (String)"user${java:version}name");
        try {
            logger.info(MarkerManager.getMarker((String)"This is a test"), "msg");
        }
        finally {
            ThreadContext.remove((String)PARAMETER);
        }
        List<String> messages = this.listAppender.getMessages();
        Assert.assertTrue((String)"No messages returned", (messages != null && messages.size() > 0 ? 1 : 0) != 0);
        String message = messages.get(0);
        Assert.assertEquals((Object)"INFO org.apache.logging.log4j.core.PatternResolverDoesNotEvaluateThreadContextTest user${java:version}name This is a test", (Object)message);
    }
}

