/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.selector;

import java.lang.reflect.Field;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.selector.TestClassLoader;
import org.apache.logging.log4j.core.util.ReflectionUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClassLoaderContextSelectorTest {
    private static final String PKG = ClassLoaderContextSelectorTest.class.getPackage().getName();
    private ClassLoader loader1;
    private ClassLoader loader2;
    private ClassLoader loader3;

    @Before
    public void setUp() throws Exception {
        this.loader1 = new TestClassLoader();
        this.loader2 = new TestClassLoader();
        this.loader3 = new TestClassLoader();
        Assert.assertNotSame((Object)this.loader1, (Object)this.loader2);
        Assert.assertNotSame((Object)this.loader1, (Object)this.loader3);
        Assert.assertNotSame((Object)this.loader2, (Object)this.loader3);
    }

    @Test
    public void testMultipleClassLoaders() throws Exception {
        Class<?> logging1 = this.loader1.loadClass(PKG + ".a.Logging1");
        Field field1 = logging1.getDeclaredField("logger");
        Logger logger1 = (Logger)ReflectionUtil.getStaticFieldValue((Field)field1);
        Assert.assertNotNull((Object)logger1);
        Class<?> logging2 = this.loader2.loadClass(PKG + ".b.Logging2");
        Field field2 = logging2.getDeclaredField("logger");
        Logger logger2 = (Logger)ReflectionUtil.getStaticFieldValue((Field)field2);
        Assert.assertNotNull((Object)logger2);
        Class<?> logging3 = this.loader3.loadClass(PKG + ".c.Logging3");
        Field field3 = logging3.getDeclaredField("logger");
        Logger logger3 = (Logger)ReflectionUtil.getStaticFieldValue((Field)field3);
        Assert.assertNotNull((Object)logger3);
        Assert.assertNotSame((Object)logger1.getContext(), (Object)logger2.getContext());
        Assert.assertNotSame((Object)logger1.getContext(), (Object)logger3.getContext());
        Assert.assertNotSame((Object)logger2.getContext(), (Object)logger3.getContext());
    }
}

