/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.pattern.EqualsReplacementConverter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.Assert;
import org.junit.Test;

public class EqualsReplacementConverterTest {
    private static final String TEST_MESSAGE = "This is a test";

    @Test
    public void testMarkerReplacement() {
        this.testReplacement("%marker", "");
    }

    @Test
    public void testMarkerSimpleNameReplacement() {
        this.testReplacement("%markerSimpleName", "");
    }

    @Test
    public void testLoggerNameReplacement() {
        this.testReplacement("%logger", "[" + EqualsReplacementConverterTest.class.getName() + "]");
    }

    @Test
    public void testMarkerReplacementWithMessage() {
        this.testReplacement(TEST_MESSAGE, new String[]{"[%marker]", "[]", "%msg"});
    }

    private void testReplacement(String tag, String expectedValue) {
        String[] options = new String[]{"[" + tag + "]", "[]", expectedValue};
        this.testReplacement(expectedValue, options);
    }

    private void testReplacement(String expectedValue, String[] options) {
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(EqualsReplacementConverterTest.class.getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage(TEST_MESSAGE)).build();
        StringBuilder sb = new StringBuilder();
        LoggerContext ctx = LoggerContext.getContext();
        EqualsReplacementConverter converter = EqualsReplacementConverter.newInstance((Configuration)ctx.getConfiguration(), (String[])options);
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((Object)expectedValue, (Object)sb.toString());
    }

    @Test
    public void testParseSubstitutionWithPattern() {
        this.testParseSubstitution("%msg", TEST_MESSAGE);
    }

    @Test
    public void testParseSubstitutionWithoutPattern() {
        String substitution = "test";
        this.testParseSubstitution("test", "test");
    }

    @Test
    public void testParseSubstitutionEmpty() {
        this.testParseSubstitution("", "");
    }

    @Test
    public void testParseSubstitutionWithWhiteSpaces() {
        this.testParseSubstitution(" ", " ");
    }

    private void testParseSubstitution(String substitution, String expected) {
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(EqualsReplacementConverterTest.class.getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage(TEST_MESSAGE)).build();
        LoggerContext ctx = LoggerContext.getContext();
        EqualsReplacementConverter converter = EqualsReplacementConverter.newInstance((Configuration)ctx.getConfiguration(), (String[])new String[]{"[%marker]", "[]", substitution});
        StringBuilder sb = new StringBuilder();
        converter.parseSubstitution((LogEvent)event, sb);
        String actual = sb.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

