/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.util.HashMap;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.lookup.MainMapLookup;
import org.apache.logging.log4j.core.lookup.MapLookup;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StringMapMessage;
import org.junit.Assert;
import org.junit.Test;

public class MapLookupTest {
    @Test
    public void testEmptyMap() {
        MapLookup lookup = new MapLookup(new HashMap());
        Assert.assertEquals(null, (Object)lookup.lookup(null));
        Assert.assertEquals(null, (Object)lookup.lookup("X"));
    }

    @Test
    public void testMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "B");
        MapLookup lookup = new MapLookup(map);
        Assert.assertEquals(null, (Object)lookup.lookup(null));
        Assert.assertEquals((Object)"B", (Object)lookup.lookup("A"));
    }

    @Test
    public void testNullMap() {
        MapLookup lookup = new MapLookup();
        Assert.assertEquals(null, (Object)lookup.lookup(null));
        Assert.assertEquals(null, (Object)lookup.lookup("X"));
    }

    @Test
    public void testMainMap() {
        MapLookup.setMainArguments((String[])new String[]{"--file", "foo.txt"});
        MapLookup lookup = MainMapLookup.MAIN_SINGLETON;
        Assert.assertEquals(null, (Object)lookup.lookup(null));
        Assert.assertEquals(null, (Object)lookup.lookup("X"));
        Assert.assertEquals((Object)"--file", (Object)lookup.lookup("0"));
        Assert.assertEquals((Object)"foo.txt", (Object)lookup.lookup("1"));
        Assert.assertEquals((Object)"foo.txt", (Object)lookup.lookup("--file"));
        Assert.assertEquals(null, (Object)lookup.lookup("foo.txt"));
    }

    @Test
    public void testEventStringMapMessage() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "B");
        HashMap<String, String> eventMap = new HashMap<String, String>();
        eventMap.put("A1", "B1");
        StringMapMessage message = new StringMapMessage(eventMap);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setMessage((Message)message).build();
        MapLookup lookup = new MapLookup(map);
        Assert.assertEquals((Object)"B", (Object)lookup.lookup((LogEvent)event, "A"));
        Assert.assertEquals((Object)"B1", (Object)lookup.lookup((LogEvent)event, "A1"));
    }

    @Test
    public void testEventMapMessage() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "B");
        HashMap<String, Integer> eventMap = new HashMap<String, Integer>();
        eventMap.put("A1", 11);
        MapMessage message = new MapMessage(eventMap);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setMessage((Message)message).build();
        MapLookup lookup = new MapLookup(map);
        Assert.assertEquals((Object)"B", (Object)lookup.lookup((LogEvent)event, "A"));
        Assert.assertEquals((Object)"11", (Object)lookup.lookup((LogEvent)event, "A1"));
    }

    @Test
    public void testLookupDefaultMapIsCheckedBeforeMapMessage() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "ADefault");
        HashMap<String, String> eventMap = new HashMap<String, String>();
        eventMap.put("A", "AEvent");
        MapMessage message = new MapMessage(eventMap);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setMessage((Message)message).build();
        MapLookup lookup = new MapLookup(map);
        Assert.assertEquals((Object)"ADefault", (Object)lookup.lookup((LogEvent)event, "A"));
    }

    @Test
    public void testNullEvent() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A", "B");
        MapLookup lookup = new MapLookup(map);
        Assert.assertEquals((Object)"B", (Object)lookup.lookup(null, "A"));
    }
}

