/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.filter.ThreadContextMapFilter;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.junit.Assert;
import org.junit.Test;

public class ThreadContextMapFilterTest {
    @Test
    public void testFilter() {
        ThreadContext.put((String)"userid", (String)"testuser");
        ThreadContext.put((String)"organization", (String)"Apache");
        KeyValuePair[] pairs = new KeyValuePair[]{new KeyValuePair("userid", "JohnDoe"), new KeyValuePair("organization", "Apache")};
        ThreadContextMapFilter filter = ThreadContextMapFilter.createFilter((KeyValuePair[])pairs, (String)"and", null, null);
        filter.start();
        Assert.assertTrue((boolean)filter.isStarted());
        Assert.assertSame((Object)Filter.Result.DENY, (Object)filter.filter(null, Level.DEBUG, null, null, (Throwable)null));
        ThreadContext.remove((String)"userid");
        Assert.assertSame((Object)Filter.Result.DENY, (Object)filter.filter(null, Level.DEBUG, null, null, (Throwable)null));
        ThreadContext.put((String)"userid", (String)"JohnDoe");
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.ERROR, null, null, (Throwable)null));
        ThreadContext.put((String)"organization", (String)"ASF");
        Assert.assertSame((Object)Filter.Result.DENY, (Object)filter.filter(null, Level.DEBUG, null, null, (Throwable)null));
        ThreadContext.clearMap();
        filter = ThreadContextMapFilter.createFilter((KeyValuePair[])pairs, (String)"or", null, null);
        filter.start();
        Assert.assertTrue((boolean)filter.isStarted());
        ThreadContext.put((String)"userid", (String)"testuser");
        ThreadContext.put((String)"organization", (String)"Apache");
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.DEBUG, null, null, (Throwable)null));
        ThreadContext.put((String)"organization", (String)"ASF");
        Assert.assertSame((Object)Filter.Result.DENY, (Object)filter.filter(null, Level.DEBUG, null, null, (Throwable)null));
        ThreadContext.remove((String)"organization");
        Assert.assertSame((Object)Filter.Result.DENY, (Object)filter.filter(null, Level.DEBUG, null, null, (Throwable)null));
        KeyValuePair[] single = new KeyValuePair[]{new KeyValuePair("userid", "testuser")};
        filter = ThreadContextMapFilter.createFilter((KeyValuePair[])single, null, null, null);
        filter.start();
        Assert.assertTrue((boolean)filter.isStarted());
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.DEBUG, null, null, (Throwable)null));
        ThreadContext.clearMap();
    }
}

