/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.core.appender.rolling.action.CountingCondition;
import org.apache.logging.log4j.core.appender.rolling.action.IfFileName;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.junit.Assert;
import org.junit.Test;

public class IfFileNameTest {
    @Test(expected=IllegalArgumentException.class)
    public void testCreateNameConditionFailsIfBothRegexAndPathAreNull() {
        IfFileName.createNameCondition(null, null, (PathCondition[])new PathCondition[0]);
    }

    @Test
    public void testCreateNameConditionAcceptsIfEitherRegexOrPathOrBothAreNonNull() {
        IfFileName.createNameCondition((String)"bar", null, (PathCondition[])new PathCondition[0]);
        IfFileName.createNameCondition(null, (String)"foo", (PathCondition[])new PathCondition[0]);
        IfFileName.createNameCondition((String)"bar", (String)"foo", (PathCondition[])new PathCondition[0]);
    }

    @Test
    public void testGetSyntaxAndPattern() {
        Assert.assertEquals((Object)"glob:path", (Object)IfFileName.createNameCondition((String)"path", null, (PathCondition[])new PathCondition[0]).getSyntaxAndPattern());
        Assert.assertEquals((Object)"glob:path", (Object)IfFileName.createNameCondition((String)"glob:path", null, (PathCondition[])new PathCondition[0]).getSyntaxAndPattern());
        Assert.assertEquals((Object)"regex:bar", (Object)IfFileName.createNameCondition(null, (String)"bar", (PathCondition[])new PathCondition[0]).getSyntaxAndPattern());
        Assert.assertEquals((Object)"regex:bar", (Object)IfFileName.createNameCondition(null, (String)"regex:bar", (PathCondition[])new PathCondition[0]).getSyntaxAndPattern());
    }

    @Test
    public void testAcceptUsesPathPatternIfExists() {
        IfFileName filter = IfFileName.createNameCondition((String)"path", (String)"regex", (PathCondition[])new PathCondition[0]);
        Path relativePath = Paths.get("path", new String[0]);
        Assert.assertTrue((boolean)filter.accept(null, relativePath, null));
        Path pathMatchingRegex = Paths.get("regex", new String[0]);
        Assert.assertFalse((boolean)filter.accept(null, pathMatchingRegex, null));
    }

    @Test
    public void testAcceptUsesRegexIfNoPathPatternExists() {
        IfFileName regexFilter = IfFileName.createNameCondition(null, (String)"regex", (PathCondition[])new PathCondition[0]);
        Path pathMatchingRegex = Paths.get("regex", new String[0]);
        Assert.assertTrue((boolean)regexFilter.accept(null, pathMatchingRegex, null));
        Path noMatch = Paths.get("nomatch", new String[0]);
        Assert.assertFalse((boolean)regexFilter.accept(null, noMatch, null));
    }

    @Test
    public void testAcceptIgnoresBasePathAndAttributes() {
        IfFileName pathFilter = IfFileName.createNameCondition((String)"path", null, (PathCondition[])new PathCondition[0]);
        Path relativePath = Paths.get("path", new String[0]);
        Assert.assertTrue((boolean)pathFilter.accept(null, relativePath, null));
        IfFileName regexFilter = IfFileName.createNameCondition(null, (String)"regex", (PathCondition[])new PathCondition[0]);
        Path pathMatchingRegex = Paths.get("regex", new String[0]);
        Assert.assertTrue((boolean)regexFilter.accept(null, pathMatchingRegex, null));
    }

    @Test
    public void testAcceptCallsNestedConditionsOnlyIfPathAccepted1() {
        CountingCondition counter = new CountingCondition(true);
        IfFileName regexFilter = IfFileName.createNameCondition(null, (String)"regex", (PathCondition[])new PathCondition[]{counter});
        Path pathMatchingRegex = Paths.get("regex", new String[0]);
        Assert.assertTrue((boolean)regexFilter.accept(null, pathMatchingRegex, null));
        Assert.assertEquals((long)1L, (long)counter.getAcceptCount());
        Assert.assertTrue((boolean)regexFilter.accept(null, pathMatchingRegex, null));
        Assert.assertEquals((long)2L, (long)counter.getAcceptCount());
        Assert.assertTrue((boolean)regexFilter.accept(null, pathMatchingRegex, null));
        Assert.assertEquals((long)3L, (long)counter.getAcceptCount());
        Path noMatch = Paths.get("nomatch", new String[0]);
        Assert.assertFalse((boolean)regexFilter.accept(null, noMatch, null));
        Assert.assertEquals((long)3L, (long)counter.getAcceptCount());
        Assert.assertFalse((boolean)regexFilter.accept(null, noMatch, null));
        Assert.assertEquals((long)3L, (long)counter.getAcceptCount());
        Assert.assertFalse((boolean)regexFilter.accept(null, noMatch, null));
        Assert.assertEquals((long)3L, (long)counter.getAcceptCount());
    }

    @Test
    public void testAcceptCallsNestedConditionsOnlyIfPathAccepted2() {
        CountingCondition counter = new CountingCondition(true);
        IfFileName globFilter = IfFileName.createNameCondition((String)"glob", null, (PathCondition[])new PathCondition[]{counter});
        Path pathMatchingGlob = Paths.get("glob", new String[0]);
        Assert.assertTrue((boolean)globFilter.accept(null, pathMatchingGlob, null));
        Assert.assertEquals((long)1L, (long)counter.getAcceptCount());
        Assert.assertTrue((boolean)globFilter.accept(null, pathMatchingGlob, null));
        Assert.assertEquals((long)2L, (long)counter.getAcceptCount());
        Assert.assertTrue((boolean)globFilter.accept(null, pathMatchingGlob, null));
        Assert.assertEquals((long)3L, (long)counter.getAcceptCount());
        Path noMatch = Paths.get("nomatch", new String[0]);
        Assert.assertFalse((boolean)globFilter.accept(null, noMatch, null));
        Assert.assertEquals((long)3L, (long)counter.getAcceptCount());
        Assert.assertFalse((boolean)globFilter.accept(null, noMatch, null));
        Assert.assertEquals((long)3L, (long)counter.getAcceptCount());
        Assert.assertFalse((boolean)globFilter.accept(null, noMatch, null));
        Assert.assertEquals((long)3L, (long)counter.getAcceptCount());
    }

    @Test
    public void testBeforeTreeWalk() {
        CountingCondition counter = new CountingCondition(true);
        IfFileName pathFilter = IfFileName.createNameCondition((String)"path", null, (PathCondition[])new PathCondition[]{counter, counter, counter});
        pathFilter.beforeFileTreeWalk();
        Assert.assertEquals((long)3L, (long)counter.getBeforeFileTreeWalkCount());
    }
}

