/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.io.File;
import java.io.PrintStream;
import org.apache.logging.log4j.core.appender.rolling.action.FileRenameAction;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class FileRenameActionTest {
    private static final String DIR = "target/fileRename";

    @BeforeClass
    public static void beforeClass() throws Exception {
        File file = new File(DIR);
        file.mkdirs();
    }

    @AfterClass
    public static void afterClass() {
        FileRenameActionTest.deleteDir();
    }

    @After
    public void after() {
        FileRenameActionTest.deleteFiles();
    }

    @Test
    public void testRename1() throws Exception {
        File file = new File("target/fileRename/fileRename.log");
        try (PrintStream pos = new PrintStream(file);){
            for (int i = 0; i < 100; ++i) {
                pos.println("This is line " + i);
            }
        }
        File dest = new File("target/fileRename/newFile.log");
        FileRenameAction action = new FileRenameAction(file, dest, false);
        action.execute();
        Assert.assertTrue((String)"Renamed file does not exist", (boolean)dest.exists());
        Assert.assertTrue((String)"Old file exists", (!file.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testEmpty() throws Exception {
        File file = new File("target/fileRename/fileRename.log");
        PrintStream pos = new PrintStream(file);
        Throwable throwable = null;
        if (pos != null) {
            if (throwable != null) {
                try {
                    pos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                pos.close();
            }
        }
        File dest = new File("target/fileRename/newFile.log");
        FileRenameAction action = new FileRenameAction(file, dest, false);
        action.execute();
        Assert.assertTrue((String)"Renamed file does not exist", (!dest.exists() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Old file does not exist", (!file.exists() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoParent() throws Exception {
        File file = new File("fileRename.log");
        try (PrintStream pos = new PrintStream(file);){
            for (int i = 0; i < 100; ++i) {
                pos.println("This is line " + i);
            }
        }
        File dest = new File("newFile.log");
        try {
            FileRenameAction action = new FileRenameAction(file, dest, false);
            action.execute();
            Assert.assertTrue((String)"Renamed file does not exist", (boolean)dest.exists());
            Assert.assertTrue((String)"Old file exists", (!file.exists() ? 1 : 0) != 0);
        }
        finally {
            try {
                dest.delete();
                file.delete();
            }
            catch (Exception ex) {
                System.out.println("Unable to cleanup files written to main directory");
            }
        }
    }

    private static void deleteDir() {
        File dir = new File(DIR);
        if (dir.exists()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                file.delete();
            }
            dir.delete();
        }
    }

    private static void deleteFiles() {
        File dir = new File(DIR);
        if (dir.exists()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                file.delete();
            }
        }
    }
}

