/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.util.Arrays;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.util.datetime.FixedDateFormat;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingAppenderDeleteAccumulatedSizeTest {
    private static final String CONFIG = "log4j-rolling-with-custom-delete-accum-size.xml";
    private static final String DIR = "target/rolling-with-delete-accum-size/test";
    private final LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-with-custom-delete-accum-size.xml");
    @Rule
    public RuleChain chain = this.loggerContextRule.withCleanFoldersRule("target/rolling-with-delete-accum-size/test");

    @Test
    public void testAppender() throws Exception {
        Object[] files;
        Logger logger = this.loggerContextRule.getLogger();
        for (int i = 0; i < 10; ++i) {
            logger.debug("This is a test message number " + i);
        }
        Thread.sleep(100L);
        File dir = new File(DIR);
        Assert.assertTrue((String)"Dir target/rolling-with-delete-accum-size/test should exist", (boolean)dir.exists());
        Assert.assertTrue((String)"Dir target/rolling-with-delete-accum-size/test should contain files", (dir.listFiles().length > 0 ? 1 : 0) != 0);
        for (Object file : files = dir.listFiles()) {
            System.out.println(file + " (" + ((File)file).length() + "B) " + FixedDateFormat.create((FixedDateFormat.FixedFormat)FixedDateFormat.FixedFormat.ABSOLUTE).format(((File)file).lastModified()));
        }
        Assert.assertEquals((String)Arrays.toString(files), (long)4L, (long)files.length);
        long total = 0L;
        for (Object file : files) {
            Assert.assertTrue((String)("unexpected file " + file), (boolean)((File)file).getName().startsWith("test-"));
            total += ((File)file).length();
        }
        Assert.assertTrue((String)("accumulatedSize=" + total), (total <= 500L ? 1 : 0) != 0);
    }
}

