/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import com.google.common.io.ByteStreams;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;

final class GarbageCollectionHelper
implements Closeable,
Runnable {
    private static final OutputStream sink = ByteStreams.nullOutputStream();
    public final AtomicBoolean running = new AtomicBoolean();
    private final CountDownLatch latch = new CountDownLatch(1);
    private final Thread gcThread = new Thread(new Runnable(){

        @Override
        public void run() {
            try {
                while (GarbageCollectionHelper.this.running.get()) {
                    try {
                        sink.write(new byte[0x100000]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    System.gc();
                }
            }
            finally {
                GarbageCollectionHelper.this.latch.countDown();
            }
        }
    });

    GarbageCollectionHelper() {
    }

    @Override
    public void run() {
        if (this.running.compareAndSet(false, true)) {
            this.gcThread.start();
        }
    }

    @Override
    public void close() {
        this.running.set(false);
        try {
            Assert.assertTrue((String)"GarbageCollectionHelper did not shut down cleanly", (boolean)this.latch.await(10L, TimeUnit.SECONDS));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

