/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;

public class FormatterLoggerManualExample {
    public static Logger logger = LogManager.getFormatterLogger((String)"Foo");

    public static void main(String[] args) {
        try (LoggerContext ctx = Configurator.initialize((String)FormatterLoggerManualExample.class.getName(), (String)"target/test-classes/log4j2-console.xml");){
            User user = new User();
            logger.debug("User %s with birthday %s", (Object)user.getName(), (Object)user.getBirthdayCalendar());
            logger.debug("User %1$s with birthday %2$tm %2$te, %2$tY", (Object)user.getName(), (Object)user.getBirthdayCalendar());
            logger.debug("Integer.MAX_VALUE = %,d", (Object)Integer.MAX_VALUE);
            logger.debug("Long.MAX_VALUE = %,d", (Object)Long.MAX_VALUE);
        }
    }

    private static class User {
        private User() {
        }

        Calendar getBirthdayCalendar() {
            return new GregorianCalendar(1995, 4, 23);
        }

        String getName() {
            return "John Smith";
        }
    }
}

