/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Queue;
import java.util.TimeZone;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationListener;
import org.apache.logging.log4j.core.config.ConfigurationScheduler;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.HttpWatcher;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.net.ssl.TestConstants;
import org.apache.logging.log4j.core.util.Source;
import org.apache.logging.log4j.core.util.WatchManager;
import org.apache.logging.log4j.core.util.Watcher;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class WatchHttpTest {
    private static final String FORCE_RUN_KEY = WatchHttpTest.class.getSimpleName() + ".forceRun";
    private final String file = "log4j-test1.xml";
    private static FastDateFormat formatter;
    private static final String XML = "application/xml";
    private static final boolean IS_WINDOWS;
    @Rule
    public WireMockRule wireMockRule = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().dynamicPort().dynamicHttpsPort().keystorePath("src/test/resources/org/apache/logging/log4j/core/net/ssl/client.log4j2-keystore.jks").keystorePassword(String.valueOf(TestConstants.KEYSTORE_PWD())).keystoreType("JKS"));

    @BeforeClass
    public static void beforeClass() {
        try {
            formatter = FastDateFormat.getInstance((String)"EEE, dd MMM yyyy HH:mm:ss", (TimeZone)TimeZone.getTimeZone("UTC"));
        }
        catch (Exception ex) {
            System.err.println("Unable to create date format.");
            ex.printStackTrace();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWatchManager() throws Exception {
        Calendar now;
        LinkedBlockingQueue<String> queue = new LinkedBlockingQueue<String>();
        ArrayList<TestConfigurationListener> listeners = new ArrayList<TestConfigurationListener>();
        listeners.add(new TestConfigurationListener(queue, "log4j-test1.xml"));
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        Calendar previous = now = Calendar.getInstance(timeZone);
        previous.add(12, -5);
        DefaultConfiguration configuration = new DefaultConfiguration();
        Assume.assumeTrue((!IS_WINDOWS || Boolean.getBoolean(FORCE_RUN_KEY) ? 1 : 0) != 0);
        URL url = new URL("http://localhost:" + this.wireMockRule.port() + "/log4j-test1.xml");
        StubMapping stubMapping = WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/log4j-test1.xml")).willReturn(WireMock.aResponse().withBodyFile("log4j-test1.xml").withStatus(200).withHeader("Last-Modified", new String[]{formatter.format(previous) + " GMT"}).withHeader("Content-Type", new String[]{XML})));
        ConfigurationScheduler scheduler = new ConfigurationScheduler();
        scheduler.incrementScheduledItems();
        WatchManager watchManager = new WatchManager(scheduler);
        watchManager.setIntervalSeconds(1);
        scheduler.start();
        watchManager.start();
        try {
            watchManager.watch(new Source(url.toURI(), previous.getTimeInMillis()), (Watcher)new HttpWatcher((Configuration)configuration, null, listeners, previous.getTimeInMillis()));
            String str = (String)queue.poll(2L, TimeUnit.SECONDS);
            Assert.assertNotNull((String)"File change not detected", (Object)str);
        }
        finally {
            WireMock.removeStub((StubMapping)stubMapping);
            watchManager.stop();
            scheduler.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotModified() throws Exception {
        Calendar now;
        LinkedBlockingQueue<String> queue = new LinkedBlockingQueue<String>();
        ArrayList<TestConfigurationListener> listeners = new ArrayList<TestConfigurationListener>();
        listeners.add(new TestConfigurationListener(queue, "log4j-test2.xml"));
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        Calendar previous = now = Calendar.getInstance(timeZone);
        previous.add(12, -5);
        DefaultConfiguration configuration = new DefaultConfiguration();
        Assume.assumeTrue((!IS_WINDOWS || Boolean.getBoolean(FORCE_RUN_KEY) ? 1 : 0) != 0);
        URL url = new URL("http://localhost:" + this.wireMockRule.port() + "/log4j-test2.xml");
        StubMapping stubMapping = WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)"/log4j-test2.xml")).willReturn(WireMock.aResponse().withBodyFile("log4j-test1.xml").withStatus(304).withHeader("Last-Modified", new String[]{formatter.format(now) + " GMT"}).withHeader("Content-Type", new String[]{XML})));
        ConfigurationScheduler scheduler = new ConfigurationScheduler();
        scheduler.incrementScheduledItems();
        WatchManager watchManager = new WatchManager(scheduler);
        watchManager.setIntervalSeconds(1);
        scheduler.start();
        watchManager.start();
        try {
            watchManager.watch(new Source(url.toURI(), previous.getTimeInMillis()), (Watcher)new HttpWatcher((Configuration)configuration, null, listeners, previous.getTimeInMillis()));
            String str = (String)queue.poll(2L, TimeUnit.SECONDS);
            Assert.assertNull((String)"File changed.", (Object)str);
        }
        finally {
            WireMock.removeStub((StubMapping)stubMapping);
            watchManager.stop();
            scheduler.stop();
        }
    }

    static {
        IS_WINDOWS = PropertiesUtil.getProperties().isOsWindows();
    }

    private class TestConfigurationListener
    implements ConfigurationListener {
        private final Queue<String> queue;
        private final String name;

        public TestConfigurationListener(Queue<String> queue, String name) {
            this.queue = queue;
            this.name = name;
        }

        public void onChange(Reconfigurable reconfigurable) {
            this.queue.add(this.name);
        }
    }
}

