/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.TestLogger;
import org.apache.logging.log4j.core.tools.Generate;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.util.MessageSupplier;
import org.apache.logging.log4j.util.Supplier;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class GenerateCustomLoggerTest {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j2.loggerContextFactory", "org.apache.logging.log4j.TestLoggerContextFactory");
    }

    @Test
    public void testGenerateSource() throws Exception {
        String[] logMethods;
        String CLASSNAME = "org.myorg.MyCustomLogger";
        List<String> values = Arrays.asList("DEFCON1=350 DEFCON2=450 DEFCON3=550".split(" "));
        List levels = Generate.LevelInfo.parse(values, Generate.CustomLogger.class);
        String src = Generate.generateSource((String)"org.myorg.MyCustomLogger", (List)levels, (Generate.Type)Generate.Type.CUSTOM);
        File f = new File("target/test-classes/org/myorg/MyCustomLogger.java");
        f.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(f);){
            out.write(src.getBytes(Charset.defaultCharset()));
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        ArrayList<String> errors = new ArrayList<String>();
        try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);){
            String[] compilationUnits = fileManager.getJavaFileObjectsFromFiles(Arrays.asList(f));
            compiler.getTask(null, fileManager, diagnostics, null, null, (Iterable<? extends JavaFileObject>)compilationUnits).call();
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                errors.add(String.format("Compile error: %s%n", diagnostic.getMessage(Locale.getDefault())));
            }
        }
        Assert.assertTrue((String)((Object)errors).toString(), (boolean)errors.isEmpty());
        Class<?> cls = Class.forName("org.myorg.MyCustomLogger");
        Assert.assertTrue((boolean)Modifier.isStatic(cls.getDeclaredMethod("create", new Class[0]).getModifiers()));
        Assert.assertTrue((boolean)Modifier.isStatic(cls.getDeclaredMethod("create", Class.class).getModifiers()));
        Assert.assertTrue((boolean)Modifier.isStatic(cls.getDeclaredMethod("create", Object.class).getModifiers()));
        Assert.assertTrue((boolean)Modifier.isStatic(cls.getDeclaredMethod("create", String.class).getModifiers()));
        Assert.assertTrue((boolean)Modifier.isStatic(cls.getDeclaredMethod("create", Class.class, MessageFactory.class).getModifiers()));
        Assert.assertTrue((boolean)Modifier.isStatic(cls.getDeclaredMethod("create", Object.class, MessageFactory.class).getModifiers()));
        Assert.assertTrue((boolean)Modifier.isStatic(cls.getDeclaredMethod("create", String.class, MessageFactory.class).getModifiers()));
        for (String string : logMethods = new String[]{"defcon1", "defcon2", "defcon3"}) {
            cls.getDeclaredMethod(string, Marker.class, Message.class, Throwable.class);
            cls.getDeclaredMethod(string, Marker.class, Object.class, Throwable.class);
            cls.getDeclaredMethod(string, Marker.class, String.class, Throwable.class);
            cls.getDeclaredMethod(string, Marker.class, Message.class);
            cls.getDeclaredMethod(string, Marker.class, Object.class);
            cls.getDeclaredMethod(string, Marker.class, String.class);
            cls.getDeclaredMethod(string, Message.class);
            cls.getDeclaredMethod(string, Object.class);
            cls.getDeclaredMethod(string, String.class);
            cls.getDeclaredMethod(string, Message.class, Throwable.class);
            cls.getDeclaredMethod(string, Object.class, Throwable.class);
            cls.getDeclaredMethod(string, String.class, Throwable.class);
            cls.getDeclaredMethod(string, String.class, Object[].class);
            cls.getDeclaredMethod(string, Marker.class, String.class, Object[].class);
            cls.getDeclaredMethod(string, Marker.class, MessageSupplier.class);
            cls.getDeclaredMethod(string, Marker.class, MessageSupplier.class, Throwable.class);
            cls.getDeclaredMethod(string, Marker.class, String.class, Supplier[].class);
            cls.getDeclaredMethod(string, Marker.class, Supplier.class);
            cls.getDeclaredMethod(string, Marker.class, Supplier.class, Throwable.class);
            cls.getDeclaredMethod(string, MessageSupplier.class);
            cls.getDeclaredMethod(string, MessageSupplier.class, Throwable.class);
            cls.getDeclaredMethod(string, String.class, Supplier[].class);
            cls.getDeclaredMethod(string, Supplier.class);
            cls.getDeclaredMethod(string, Supplier.class, Throwable.class);
        }
        Method create = cls.getDeclaredMethod("create", String.class);
        Object customLogger = create.invoke(null, "X.Y.Z");
        int n = 0;
        for (String name : logMethods) {
            Method method = cls.getDeclaredMethod(name, String.class);
            method.invoke(customLogger, "This is message " + n++);
        }
        TestLogger testLogger = (TestLogger)LogManager.getLogger((String)"X.Y.Z");
        List lines = testLogger.getEntries();
        for (int i = 0; i < lines.size(); ++i) {
            Assert.assertEquals((Object)(" " + ((Generate.LevelInfo)levels.get((int)i)).name + " This is message " + i), lines.get(i));
        }
    }
}

