/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.Calendar;
import java.util.TimeZone;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.filter.TimeFilter;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.util.Clock;
import org.apache.logging.log4j.core.util.ClockFactoryTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TimeFilterTest {
    private static long CLOCKTIME = System.currentTimeMillis();

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j.Clock", FixedTimeClock.class.getName());
    }

    @AfterClass
    public static void afterClass() throws IllegalAccessException {
        ClockFactoryTest.resetClocks();
    }

    @Test
    public void testTime() {
        TimeFilter filter = TimeFilter.createFilter((String)"02:00:00", (String)"03:00:00", (String)"America/LosAngeles", null, null);
        filter.start();
        Assert.assertTrue((boolean)filter.isStarted());
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("America/LosAngeles"));
        cal.set(11, 2);
        CLOCKTIME = cal.getTimeInMillis();
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.ERROR, null, null, (Throwable)null));
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event));
        cal.roll(5, true);
        CLOCKTIME = cal.getTimeInMillis();
        event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event));
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.ERROR, null, null, (Throwable)null));
        cal.set(11, 4);
        CLOCKTIME = cal.getTimeInMillis();
        event = Log4jLogEvent.newBuilder().setTimeMillis(CLOCKTIME).build();
        Assert.assertSame((Object)Filter.Result.DENY, (Object)filter.filter(null, Level.ERROR, null, null, (Throwable)null));
        Assert.assertSame((Object)Filter.Result.DENY, (Object)filter.filter((LogEvent)event));
    }

    public static class FixedTimeClock
    implements Clock {
        public long currentTimeMillis() {
            return CLOCKTIME;
        }
    }
}

