/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async.perftest;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.core.spi.LifeCycle;
import org.apache.logging.log4j.core.async.perftest.Histogram;
import org.apache.logging.log4j.core.async.perftest.IPerfTestRunner;
import org.slf4j.LoggerFactory;

public class RunLogback
implements IPerfTestRunner {
    final Logger LOGGER = (Logger)LoggerFactory.getLogger(this.getClass());

    @Override
    public void runThroughputTest(int lines, Histogram histogram) {
        long s1 = System.nanoTime();
        Logger logger = this.LOGGER;
        for (int j = 0; j < lines; ++j) {
            logger.info("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890!\"#$%&'()-=^~|\\@`[]{};:+*,.<>/?_123456ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890!\"#$%&'()-=^~|\\@`[]{};:+*,.<>/?_123456ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890!\"#$%&'()-=^~|\\@`[]{};:+*,.<>/?_123456ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890!\"#$%&'()-=^~|\\@`[]{};:+*,.<>/?_123456ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890!\"#$%&'()-=^~|\\@`[]{};:+*,.<>/?_123456");
        }
        long s2 = System.nanoTime();
        long opsPerSec = 1000000000L * (long)lines / (s2 - s1);
        histogram.addObservation(opsPerSec);
    }

    @Override
    public void runLatencyTest(int samples, Histogram histogram, long nanoTimeCost, int threadCount) {
        Logger logger = this.LOGGER;
        for (int i = 0; i < samples; ++i) {
            long s1 = System.nanoTime();
            logger.info("Short msg");
            long s2 = System.nanoTime();
            long value = s2 - s1 - nanoTimeCost;
            if (value > 0L) {
                histogram.addObservation(value);
            }
            long PAUSE_NANOS = 10000 * threadCount;
            long pauseStart = System.nanoTime();
            while (PAUSE_NANOS > System.nanoTime() - pauseStart) {
            }
        }
    }

    @Override
    public void shutdown() {
        ((LifeCycle)LoggerFactory.getILoggerFactory()).stop();
    }

    @Override
    public void log(String msg) {
        this.LOGGER.info(msg);
    }
}

