/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class AsyncLoggerConfigWithAsyncEnabledTest {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j2.is.webapp", "false");
        System.setProperty("Log4jContextSelector", AsyncLoggerContextSelector.class.getCanonicalName());
        System.setProperty("log4j.configurationFile", "AsyncLoggerConfigTest4.xml");
    }

    @AfterClass
    public static void afterClass() {
        System.clearProperty("log4j2.is.webapp");
        System.clearProperty("Log4jContextSelector");
    }

    @Test
    public void testParametersAreAvailableToLayout() throws Exception {
        File file = new File("target", "AsyncLoggerConfigTest4.log");
        Assert.assertTrue((String)"Deleted old file before test", (!file.exists() || file.delete() ? 1 : 0) != 0);
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        String format = "Additive logging: {} for the price of {}!";
        log.info("Additive logging: {} for the price of {}!", (Object)2, (Object)1);
        CoreLoggerContexts.stopLoggerContext(file);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line1 = reader.readLine();
        String line2 = reader.readLine();
        reader.close();
        file.delete();
        String expected = "Additive logging: {} for the price of {}! [2,1] Additive logging: 2 for the price of 1!";
        Assert.assertThat((Object)line1, (Matcher)Matchers.containsString((String)"Additive logging: {} for the price of {}! [2,1] Additive logging: 2 for the price of 1!"));
        Assert.assertThat((Object)line2, (Matcher)Matchers.containsString((String)"Additive logging: {} for the price of {}! [2,1] Additive logging: 2 for the price of 1!"));
    }
}

