/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import org.apache.logging.log4j.core.appender.rolling.action.Duration;
import org.junit.Assert;
import org.junit.Test;

public class DurationTest {
    @Test(expected=NullPointerException.class)
    public void testParseFailsIfNullText() {
        Duration.parse(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseFailsIfInvalidPattern() {
        Duration.parse((CharSequence)"abc");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseFailsIfSectionsOutOfOrder() {
        Duration.parse((CharSequence)"P4DT2M1S3H");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseFailsIfTButMissingTime() {
        Duration.parse((CharSequence)"P1dT");
    }

    @Test
    public void testParseIsCaseInsensitive() {
        Assert.assertEquals((Object)"P4DT3H2M1S", (Object)Duration.parse((CharSequence)"p4dt3h2m1s").toString());
    }

    @Test
    public void testParseAllowsOverflows() {
        Assert.assertEquals((long)70000L, (long)Duration.parse((CharSequence)"PT70S").toMillis());
        Assert.assertEquals((long)4200000L, (long)Duration.parse((CharSequence)"PT70M").toMillis());
        Assert.assertEquals((long)90000000L, (long)Duration.parse((CharSequence)"PT25H").toMillis());
    }

    @Test
    public void testToMillis() {
        Assert.assertEquals((long)0L, (long)Duration.ZERO.toMillis());
        Assert.assertEquals((long)1000L, (long)Duration.parse((CharSequence)"PT1S").toMillis());
        Assert.assertEquals((long)120000L, (long)Duration.parse((CharSequence)"PT2M").toMillis());
        Assert.assertEquals((long)10800000L, (long)Duration.parse((CharSequence)"PT3H").toMillis());
        Assert.assertEquals((long)345600000L, (long)Duration.parse((CharSequence)"P4D").toMillis());
        long expected = 356521000L;
        Assert.assertEquals((long)356521000L, (long)Duration.parse((CharSequence)"P4DT3H2M1S").toMillis());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"PT0S", (Object)Duration.ZERO.toString());
        Assert.assertEquals((Object)"PT1S", (Object)Duration.parse((CharSequence)"PT1S").toString());
        Assert.assertEquals((Object)"PT2M1S", (Object)Duration.parse((CharSequence)"PT2M1S").toString());
        Assert.assertEquals((Object)"PT3H2M1S", (Object)Duration.parse((CharSequence)"PT3H2M1S").toString());
        Assert.assertEquals((Object)"P4DT3H2M1S", (Object)Duration.parse((CharSequence)"P4DT3H2M1S").toString());
    }

    @Test
    public void testPrefixPNotRequired() {
        Assert.assertEquals((Object)"PT1S", (Object)Duration.parse((CharSequence)"T1S").toString());
        Assert.assertEquals((Object)"PT2M1S", (Object)Duration.parse((CharSequence)"T2M1S").toString());
        Assert.assertEquals((Object)"PT3H2M1S", (Object)Duration.parse((CharSequence)"T3H2M1S").toString());
        Assert.assertEquals((Object)"P4DT3H2M1S", (Object)Duration.parse((CharSequence)"4DT3H2M1S").toString());
    }

    @Test
    public void testInfixTNotRequired() {
        Assert.assertEquals((Object)"PT1S", (Object)Duration.parse((CharSequence)"P1S").toString());
        Assert.assertEquals((Object)"PT2M1S", (Object)Duration.parse((CharSequence)"P2M1S").toString());
        Assert.assertEquals((Object)"PT3H2M1S", (Object)Duration.parse((CharSequence)"P3H2M1S").toString());
        Assert.assertEquals((Object)"P4DT3H2M1S", (Object)Duration.parse((CharSequence)"P4D3H2M1S").toString());
    }

    @Test
    public void testPrefixPAndInfixTNotRequired() {
        Assert.assertEquals((Object)"PT1S", (Object)Duration.parse((CharSequence)"1S").toString());
        Assert.assertEquals((Object)"PT2M1S", (Object)Duration.parse((CharSequence)"2M1S").toString());
        Assert.assertEquals((Object)"PT3H2M1S", (Object)Duration.parse((CharSequence)"3H2M1S").toString());
        Assert.assertEquals((Object)"P4DT3H2M1S", (Object)Duration.parse((CharSequence)"4D3H2M1S").toString());
    }

    @Test
    public void testCompareTo() {
        Assert.assertEquals((long)-1L, (long)Duration.parse((CharSequence)"PT1S").compareTo(Duration.parse((CharSequence)"PT2S")));
        Assert.assertEquals((long)-1L, (long)Duration.parse((CharSequence)"PT1M").compareTo(Duration.parse((CharSequence)"PT2M")));
        Assert.assertEquals((long)-1L, (long)Duration.parse((CharSequence)"PT1H").compareTo(Duration.parse((CharSequence)"PT2H")));
        Assert.assertEquals((long)-1L, (long)Duration.parse((CharSequence)"P1D").compareTo(Duration.parse((CharSequence)"P2D")));
        Assert.assertEquals((long)0L, (long)Duration.parse((CharSequence)"PT1S").compareTo(Duration.parse((CharSequence)"PT1S")));
        Assert.assertEquals((long)0L, (long)Duration.parse((CharSequence)"PT1M").compareTo(Duration.parse((CharSequence)"PT1M")));
        Assert.assertEquals((long)0L, (long)Duration.parse((CharSequence)"PT1H").compareTo(Duration.parse((CharSequence)"PT1H")));
        Assert.assertEquals((long)0L, (long)Duration.parse((CharSequence)"P1D").compareTo(Duration.parse((CharSequence)"P1D")));
        Assert.assertEquals((long)1L, (long)Duration.parse((CharSequence)"PT2S").compareTo(Duration.parse((CharSequence)"PT1S")));
        Assert.assertEquals((long)1L, (long)Duration.parse((CharSequence)"PT2M").compareTo(Duration.parse((CharSequence)"PT1M")));
        Assert.assertEquals((long)1L, (long)Duration.parse((CharSequence)"PT2H").compareTo(Duration.parse((CharSequence)"PT1H")));
        Assert.assertEquals((long)1L, (long)Duration.parse((CharSequence)"P2D").compareTo(Duration.parse((CharSequence)"P1D")));
        Assert.assertEquals((long)0L, (long)Duration.parse((CharSequence)"PT1M").compareTo(Duration.parse((CharSequence)"PT60S")));
        Assert.assertEquals((long)0L, (long)Duration.parse((CharSequence)"PT1H").compareTo(Duration.parse((CharSequence)"PT60M")));
        Assert.assertEquals((long)0L, (long)Duration.parse((CharSequence)"PT1H").compareTo(Duration.parse((CharSequence)"PT3600S")));
        Assert.assertEquals((long)0L, (long)Duration.parse((CharSequence)"P1D").compareTo(Duration.parse((CharSequence)"PT24H")));
        Assert.assertEquals((long)0L, (long)Duration.parse((CharSequence)"P1D").compareTo(Duration.parse((CharSequence)"PT1440M")));
    }

    @Test
    public void testEquals() {
        Assert.assertNotEquals((Object)Duration.parse((CharSequence)"PT1S"), (Object)Duration.parse((CharSequence)"PT2S"));
        Assert.assertNotEquals((Object)Duration.parse((CharSequence)"PT1M"), (Object)Duration.parse((CharSequence)"PT2M"));
        Assert.assertNotEquals((Object)Duration.parse((CharSequence)"PT1H"), (Object)Duration.parse((CharSequence)"PT2H"));
        Assert.assertNotEquals((Object)Duration.parse((CharSequence)"P1D"), (Object)Duration.parse((CharSequence)"P2D"));
        Assert.assertEquals((Object)Duration.parse((CharSequence)"PT1S"), (Object)Duration.parse((CharSequence)"PT1S"));
        Assert.assertEquals((Object)Duration.parse((CharSequence)"PT1M"), (Object)Duration.parse((CharSequence)"PT1M"));
        Assert.assertEquals((Object)Duration.parse((CharSequence)"PT1H"), (Object)Duration.parse((CharSequence)"PT1H"));
        Assert.assertEquals((Object)Duration.parse((CharSequence)"P1D"), (Object)Duration.parse((CharSequence)"P1D"));
        Assert.assertEquals((Object)Duration.parse((CharSequence)"PT1M"), (Object)Duration.parse((CharSequence)"PT60S"));
        Assert.assertEquals((Object)Duration.parse((CharSequence)"PT1H"), (Object)Duration.parse((CharSequence)"PT60M"));
        Assert.assertEquals((Object)Duration.parse((CharSequence)"PT1H"), (Object)Duration.parse((CharSequence)"PT3600S"));
        Assert.assertEquals((Object)Duration.parse((CharSequence)"P1D"), (Object)Duration.parse((CharSequence)"PT24H"));
        Assert.assertEquals((Object)Duration.parse((CharSequence)"P1D"), (Object)Duration.parse((CharSequence)"PT1440M"));
    }
}

