/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class RollingRandomAccessFileAppenderRolloverTest {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j.configurationFile", "RollingRandomAccessFileAppenderTest.xml");
    }

    @Test
    @Ignore
    public void testRollover() throws Exception {
        File file = new File("target", "RollingRandomAccessFileAppenderTest.log");
        File after1 = new File("target", "afterRollover-1.log");
        file.delete();
        after1.delete();
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        String msg = "First a short message that does not trigger rollover";
        log.info("First a short message that does not trigger rollover");
        Thread.sleep(50L);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line1 = reader.readLine();
        Assert.assertTrue((boolean)line1.contains("First a short message that does not trigger rollover"));
        reader.close();
        Assert.assertFalse((String)"afterRollover-1.log not created yet", (boolean)after1.exists());
        String exceed = "Long message that exceeds rollover size... ";
        char[] padding = new char[250];
        Arrays.fill(padding, 'X');
        exceed = exceed + new String(padding);
        log.warn(exceed);
        Assert.assertFalse((String)"exceeded size but afterRollover-1.log not created yet", (boolean)after1.exists());
        String trigger = "This message triggers rollover.";
        log.warn("This message triggers rollover.");
        Thread.sleep(100L);
        log.warn("This message triggers rollover.");
        CoreLoggerContexts.stopLoggerContext();
        CoreLoggerContexts.stopLoggerContext(false);
        int MAX_ATTEMPTS = 50;
        int count = 0;
        while (!after1.exists() && count++ < 50) {
            Thread.sleep(50L);
        }
        Assert.assertTrue((String)"afterRollover-1.log created", (boolean)after1.exists());
        reader = new BufferedReader(new FileReader(file));
        String new1 = reader.readLine();
        Assert.assertTrue((String)"after rollover only new msg", (boolean)new1.contains("This message triggers rollover."));
        Assert.assertNull((String)"No more lines", (Object)reader.readLine());
        reader.close();
        file.delete();
        reader = new BufferedReader(new FileReader(after1));
        String old1 = reader.readLine();
        Assert.assertTrue((String)"renamed file line 1", (boolean)old1.contains("First a short message that does not trigger rollover"));
        String old2 = reader.readLine();
        Assert.assertTrue((String)"renamed file line 2", (boolean)old2.contains(exceed));
        String line = reader.readLine();
        if (line != null) {
            Assert.assertTrue((String)"strange...", (boolean)line.contains("This message triggers rollover."));
            line = reader.readLine();
        }
        Assert.assertNull((String)"No more lines", (Object)line);
        reader.close();
        after1.delete();
    }
}

