/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.categories.Appenders;
import org.apache.logging.log4j.core.appender.AsyncAppender;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={Appenders.AsyncConversant.class, Appenders.AsyncJcTools.class})
public class AsyncAppenderTest {
    private static final long TIMEOUT_MILLIS = 2000L;
    @Rule
    public LoggerContextRule context;
    private ListAppender listAppender;

    @Parameterized.Parameters(name="{0}")
    public static Object[] data() {
        return new String[]{"log4j-asynch.xml", "BlockingQueueFactory-ArrayBlockingQueue.xml", "BlockingQueueFactory-DisruptorBlockingQueue.xml", "BlockingQueueFactory-JCToolsBlockingQueue.xml", "BlockingQueueFactory-LinkedTransferQueue.xml"};
    }

    public AsyncAppenderTest(String configFileName) {
        this.context = new LoggerContextRule(configFileName);
    }

    @Before
    public void before() throws Exception {
        this.listAppender = this.context.getListAppender("List");
    }

    @After
    public void after() {
        this.listAppender.clear();
    }

    @Test
    public void rewriteTest() throws Exception {
        Logger logger = LogManager.getLogger(AsyncAppender.class);
        logger.error("This is a test");
        logger.warn("Hello world!");
        long timeoutMillis = 2000L;
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        List<String> list = this.listAppender.getMessages(2, 2000L, timeUnit);
        Assert.assertNotNull((String)"No events generated", list);
        Assert.assertTrue((String)("Incorrect number of events after 2000 " + (Object)((Object)timeUnit) + ". Expected 2, got " + list.size()), (list.size() == 2 ? 1 : 0) != 0);
        String msg = list.get(0);
        String expected = AsyncAppenderTest.class.getName() + " rewriteTest This is a test";
        Assert.assertTrue((String)("Expected " + expected + ", Actual " + msg), (boolean)expected.equals(msg));
        msg = list.get(1);
        expected = AsyncAppenderTest.class.getName() + " rewriteTest Hello world!";
        Assert.assertTrue((String)("Expected " + expected + ", Actual " + msg), (boolean)expected.equals(msg));
    }

    @Test
    public void testException() throws Exception {
        Logger logger = LogManager.getLogger(AsyncAppender.class);
        IllegalStateException parent = new IllegalStateException("Test");
        LoggingException child = new LoggingException("This is a test", (Throwable)parent);
        logger.error("This is a test", (Throwable)child);
        long timeoutMillis = 2000L;
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        List<String> list = this.listAppender.getMessages(1, 2000L, timeUnit);
        Assert.assertNotNull((String)"No events generated", list);
        Assert.assertTrue((String)("Incorrect number of events after 2000 " + (Object)((Object)timeUnit) + ". Expected 1, got " + list.size()), (list.size() == 1 ? 1 : 0) != 0);
        String msg = list.get(0);
        Assert.assertTrue((String)"No parent exception", (boolean)msg.contains("java.lang.IllegalStateException"));
    }
}

