/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.util.Locale;
import org.apache.logging.log4j.EventLogger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.junit.ClassRule;
import org.junit.Test;

public class XmlEvents {
    private static final String CONFIG = "xml-events.xml";
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("xml-events.xml");

    @Test
    public void testEvents() {
        ThreadContext.put((String)"loginId", (String)"JohnDoe");
        ThreadContext.put((String)"ipAddress", (String)"192.168.0.120");
        ThreadContext.put((String)"locale", (String)Locale.US.getDisplayName());
        TransferMessage msg = new TransferMessage();
        msg.put("ToAccount", "123456");
        msg.put("FromAccount", "123457");
        msg.put("Amount", "200.00");
        EventLogger.logEvent((StructuredDataMessage)msg);
        msg.setCompletionStatus("Transfer Complete");
        EventLogger.logEvent((StructuredDataMessage)msg);
        ThreadContext.clearMap();
    }

    @AsynchronouslyFormattable
    private static class TransferMessage
    extends StructuredDataMessage {
        private static final long serialVersionUID = -4334703653495359785L;

        public TransferMessage() {
            super("Transfer@18060", null, "Audit");
        }

        public void setCompletionStatus(String msg) {
            this.setMessageFormat(msg);
        }
    }
}

