/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.flume.appender;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.flume.Event;
import org.apache.flume.api.RpcClient;
import org.apache.flume.api.RpcClientFactory;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.flume.appender.AbstractFlumeManager;
import org.apache.logging.log4j.flume.appender.Agent;
import org.apache.logging.log4j.flume.appender.BatchEvent;

public class FlumeAvroManager
extends AbstractFlumeManager {
    private static final int MAX_RECONNECTS = 3;
    private static final int MINIMUM_TIMEOUT = 1000;
    private static AvroManagerFactory factory = new AvroManagerFactory();
    private final Agent[] agents;
    private final int batchSize;
    private final long delayNanos;
    private final int delayMillis;
    private final int retries;
    private final int connectTimeoutMillis;
    private final int requestTimeoutMillis;
    private final int current = 0;
    private volatile RpcClient rpcClient = null;
    private BatchEvent batchEvent = new BatchEvent();
    private long nextSend = 0L;

    protected FlumeAvroManager(String name, String shortName, Agent[] agents, int batchSize, int delayMillis, int retries, int connectTimeout, int requestTimeout) {
        super(name);
        this.agents = agents;
        this.batchSize = batchSize;
        this.delayMillis = delayMillis;
        this.delayNanos = TimeUnit.MILLISECONDS.toNanos(delayMillis);
        this.retries = retries;
        this.connectTimeoutMillis = connectTimeout;
        this.requestTimeoutMillis = requestTimeout;
        this.rpcClient = this.connect(agents, retries, connectTimeout, requestTimeout);
    }

    public static FlumeAvroManager getManager(String name, Agent[] agents, int batchSize, int delayMillis, int retries, int connectTimeoutMillis, int requestTimeoutMillis) {
        if (agents == null || agents.length == 0) {
            throw new IllegalArgumentException("At least one agent is required");
        }
        if (batchSize <= 0) {
            batchSize = 1;
        }
        StringBuilder sb = new StringBuilder(name);
        sb.append(" FlumeAvro[");
        boolean first = true;
        for (Agent agent : agents) {
            if (!first) {
                sb.append(',');
            }
            sb.append(agent.getHost()).append(':').append(agent.getPort());
            first = false;
        }
        sb.append(']');
        return (FlumeAvroManager)FlumeAvroManager.getManager((String)sb.toString(), (ManagerFactory)factory, (Object)new FactoryData(name, agents, batchSize, delayMillis, retries, connectTimeoutMillis, requestTimeoutMillis));
    }

    public Agent[] getAgents() {
        return this.agents;
    }

    public int getCurrent() {
        return 0;
    }

    public int getRetries() {
        return this.retries;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public int getRequestTimeoutMillis() {
        return this.requestTimeoutMillis;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getDelayMillis() {
        return this.delayMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(BatchEvent events) {
        if (this.rpcClient == null) {
            FlumeAvroManager flumeAvroManager = this;
            synchronized (flumeAvroManager) {
                if (this.rpcClient == null) {
                    this.rpcClient = this.connect(this.agents, this.retries, this.connectTimeoutMillis, this.requestTimeoutMillis);
                }
            }
        }
        if (this.rpcClient != null) {
            try {
                LOGGER.trace("Sending batch of {} events", (Object)events.getEvents().size());
                this.rpcClient.appendBatch(events.getEvents());
            }
            catch (Exception ex) {
                this.rpcClient.close();
                this.rpcClient = null;
                String msg = "Unable to write to " + this.getName() + " at " + this.agents[0].getHost() + ':' + this.agents[0].getPort();
                LOGGER.warn(msg, (Throwable)ex);
                throw new AppenderLoggingException("No Flume agents are available");
            }
        } else {
            String msg = "Unable to write to " + this.getName() + " at " + this.agents[0].getHost() + ':' + this.agents[0].getPort();
            LOGGER.warn(msg);
            throw new AppenderLoggingException("No Flume agents are available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Event event) {
        if (this.batchSize == 1) {
            if (this.rpcClient == null) {
                this.rpcClient = this.connect(this.agents, this.retries, this.connectTimeoutMillis, this.requestTimeoutMillis);
            }
            if (this.rpcClient != null) {
                try {
                    this.rpcClient.append(event);
                }
                catch (Exception ex) {
                    this.rpcClient.close();
                    this.rpcClient = null;
                    String msg = "Unable to write to " + this.getName() + " at " + this.agents[0].getHost() + ':' + this.agents[0].getPort();
                    LOGGER.warn(msg, (Throwable)ex);
                    throw new AppenderLoggingException("No Flume agents are available");
                }
            }
            String msg = "Unable to write to " + this.getName() + " at " + this.agents[0].getHost() + ':' + this.agents[0].getPort();
            LOGGER.warn(msg);
            throw new AppenderLoggingException("No Flume agents are available");
        }
        BatchEvent batch = null;
        BatchEvent batchEvent = this.batchEvent;
        synchronized (batchEvent) {
            this.batchEvent.addEvent(event);
            int eventCount = this.batchEvent.size();
            long now = System.nanoTime();
            if (eventCount == 1) {
                this.nextSend = now + this.delayNanos;
            }
            if (eventCount >= this.batchSize || now >= this.nextSend) {
                batch = this.batchEvent;
                this.batchEvent = new BatchEvent();
            }
        }
        if (batch != null) {
            this.send(batch);
        }
    }

    private RpcClient connect(Agent[] agents, int retries, int connectTimeoutMillis, int requestTimeoutMillis) {
        try {
            Properties props = new Properties();
            props.put("client.type", "default_failover");
            int agentCount = 1;
            StringBuilder sb = new StringBuilder();
            for (Agent agent : agents) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                String hostName = "host" + agentCount++;
                props.put("hosts." + hostName, agent.getHost() + ':' + agent.getPort());
                sb.append(hostName);
            }
            props.put("hosts", sb.toString());
            if (this.batchSize > 0) {
                props.put("batch-size", Integer.toString(this.batchSize));
            }
            if (retries > 1) {
                if (retries > 3) {
                    retries = 3;
                }
                props.put("max-attempts", Integer.toString(retries * agents.length));
            }
            if (requestTimeoutMillis >= 1000) {
                props.put("request-timeout", Integer.toString(requestTimeoutMillis));
            }
            if (connectTimeoutMillis >= 1000) {
                props.put("connect-timeout", Integer.toString(connectTimeoutMillis));
            }
            return RpcClientFactory.getInstance((Properties)props);
        }
        catch (Exception ex) {
            LOGGER.error("Unable to create Flume RPCClient: {}", (Object)ex.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean releaseSub(long timeout, TimeUnit timeUnit) {
        boolean closed = true;
        if (this.rpcClient != null) {
            try {
                FlumeAvroManager flumeAvroManager = this;
                synchronized (flumeAvroManager) {
                    try {
                        if (this.batchSize > 1 && this.batchEvent.getEvents().size() > 0) {
                            this.send(this.batchEvent);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error sending final batch: {}", (Object)ex.getMessage());
                        closed = false;
                    }
                }
                this.rpcClient.close();
            }
            catch (Exception ex) {
                LOGGER.error("Attempt to close RPC client failed", (Throwable)ex);
                closed = false;
            }
        }
        this.rpcClient = null;
        return closed;
    }

    private static class AvroManagerFactory
    implements ManagerFactory<FlumeAvroManager, FactoryData> {
        private AvroManagerFactory() {
        }

        public FlumeAvroManager createManager(String name, FactoryData data) {
            try {
                return new FlumeAvroManager(name, data.name, data.agents, data.batchSize, data.delayMillis, data.retries, data.conntectTimeoutMillis, data.requestTimeoutMillis);
            }
            catch (Exception ex) {
                LOGGER.error("Could not create FlumeAvroManager", (Throwable)ex);
                return null;
            }
        }
    }

    private static class FactoryData {
        private final String name;
        private final Agent[] agents;
        private final int batchSize;
        private final int delayMillis;
        private final int retries;
        private final int conntectTimeoutMillis;
        private final int requestTimeoutMillis;

        public FactoryData(String name, Agent[] agents, int batchSize, int delayMillis, int retries, int connectTimeoutMillis, int requestTimeoutMillis) {
            this.name = name;
            this.agents = agents;
            this.batchSize = batchSize;
            this.delayMillis = delayMillis;
            this.retries = retries;
            this.conntectTimeoutMillis = connectTimeoutMillis;
            this.requestTimeoutMillis = requestTimeoutMillis;
        }
    }
}

