<!---
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->
# Apache Log4j 2.12.0 Release Notes

The Apache Log4j 2 team is pleased to announce the Log4j 2.12.0 release!

Apache Log4j is a well known framework for logging application behavior. Log4j 2 is an upgrade
to Log4j that provides significant improvements over its predecessor, Log4j 1.x, and provides
many other modern features such as support for Markers, lambda expressions for lazy logging,
property substitution using Lookups, multiple patterns on a PatternLayout and asynchronous
Loggers. Another notable Log4j 2 feature is the ability to be "garbage-free" (avoid allocating
temporary objects) while logging. In addition, Log4j 2 will not lose events while reconfiguring.

The artifacts may be downloaded from https://logging.apache.org/log4j/2.x/download.html.

This release contains bugfixes and minor enhancements.

Due to a break in compatibility in the SLF4J binding, Log4j now ships with two versions of the SLF4J to Log4j adapters.
log4j-slf4j-impl should be used with SLF4J 1.7.x and earlier and log4j-slf4j18-impl should be used with SLF4J 1.8.x and
later.

New features include support for reconnfiguration of Log4j configuraton files accessed via HTTP(s) and Spring Cloud
Config specifically,  a new Docker Lookup for obtaining information about the current Docker container, new
reconfiguration methods added to the Configurator class, the
ability to pad integers with leading zeros in filenames generated by the rolling file appenders, and allowing the TCP
SocketAppender to connect to mulitple ip addresses when they are returned from DNS.

More details on the new features and fixes are itemized below.

Note that the XML, JSON and YAML formats changed in the 2.11.0 release: they no longer have the "timeMillis" attribute
and instead have an "Instant" element with "epochSecond" and "nanoOfSecond" attributes.

The Log4j 2.12.0 API, as well as many core components, maintains binary compatibility with previous releases.

## GA Release 2.12.0

Changes in this version include:

### New Features
* [LOG4J2-2403](https://issues.apache.org/jira/browse/LOG4J2-2403):
Allow zero padding the counter of a RollingFileAppender. Thanks to hupfdule.
* [LOG4J2-2427](https://issues.apache.org/jira/browse/LOG4J2-2427):
Add filter that will match events when no marker is present. Thanks to Rimaljit Kaur.
* [LOG4J2-2406](https://issues.apache.org/jira/browse/LOG4J2-2406):
Add reconfiguration methods to Configurator.
* [LOG4J2-913](https://issues.apache.org/jira/browse/LOG4J2-913):
Add support for reconfiguration via HTTP(S), Docker, and Spring Cloud Configuration.
* [LOG4J2-2586](https://issues.apache.org/jira/browse/LOG4J2-2586):
TCP Appender should support a host name resolving to multiple IP addresses.
* [LOG4J2-2337](https://issues.apache.org/jira/browse/LOG4J2-2337):
Allow custom end-of-line with JsonLayout. Thanks to Arvind Sahare, Patrice Ferrot.
* [LOG4J2-2598](https://issues.apache.org/jira/browse/LOG4J2-2598):
GZIP compression on rollover supports configurable compression levels. Thanks to Carter Kozak.
* [LOG4J2-2611](https://issues.apache.org/jira/browse/LOG4J2-2611):
AsyncQueueFullPolicy configuration short values "Default" and "Discard" are case insensitive to avoid confusion.
* [LOG4J2-2634](https://issues.apache.org/jira/browse/LOG4J2-2634):
Add and use method org.apache.logging.log4j.message.MapMessage.toKey(String) for simpler subclasses.

### Fixed Bugs
* [LOG4J2-2547](https://issues.apache.org/jira/browse/LOG4J2-2547):
RollingRandomAccessFileAppender error message referenced incorrect class name.
* [LOG4J2-2616](https://issues.apache.org/jira/browse/LOG4J2-2616):
Restore constructor to ThrowablePatternConverter that was removed in 2.8.2.
* [LOG4J2-2622](https://issues.apache.org/jira/browse/LOG4J2-2622):
StructuredDataId was ignoring maxLength atribute.
* [LOG4J2-2636](https://issues.apache.org/jira/browse/LOG4J2-2636):
RFC5424Layout was not properly setting default Structured Element id for the MDC
* [LOG4J2-1143](https://issues.apache.org/jira/browse/LOG4J2-1143):
Lookups were not found if the plugin key was not lowercase. Thanks to Pascal Heinrich.
* [LOG4J2-1852](https://issues.apache.org/jira/browse/LOG4J2-1852):
Locate plugins within a Jar using a URL Connection. Thanks to Tanner Altares.
* [LOG4J2-2610](https://issues.apache.org/jira/browse/LOG4J2-2610):
Explicitly set file creation time.
* [LOG4J2-2561](https://issues.apache.org/jira/browse/LOG4J2-2561):
JEP223 version detection fix for JDK 9 and up. Thanks to Ulrich Enslin.
* [LOG4J2-1103](https://issues.apache.org/jira/browse/LOG4J2-1103):
FailoverAppender was failing with ERROR appender Failover has no parameter that matches element Failovers. Thanks to Seán Dunne.
* [LOG4J2-2602](https://issues.apache.org/jira/browse/LOG4J2-2602):
Update file time when size based triggering policy is used without a time-based triggering policy.
* [LOG4J2-2597](https://issues.apache.org/jira/browse/LOG4J2-2597):
Throw better exception message when both log4j-slf4j-impl and log4j-to-slf4j are present.
* [LOG4J2-2559](https://issues.apache.org/jira/browse/LOG4J2-2559):
NullPointerException in JdbcAppender.createAppender(). Thanks to Li Lei, Gary Gregory.
* [LOG4J2-2592](https://issues.apache.org/jira/browse/LOG4J2-2592):
StackOverflowException when server not reachable with SocketAppender. Thanks to Dávid Kaya, Gary Gregory.
* [LOG4J2-2598](https://issues.apache.org/jira/browse/LOG4J2-2598):
java.lang.StackOverflowError at org.apache.logging.log4j.junit.AbstractExternalFileCleaner.println(AbstractExternalFileCleaner.java:169). Thanks to Gary Gregory.
* [LOG4J2-2564](https://issues.apache.org/jira/browse/LOG4J2-2564):
MapPatternConverter is properly created from the '%K', '%map', and '%MAP' patterns.
        PatternConverter instanceOf methods with unknown parameter types no longer elide those with known parameters.
* [LOG4J2-2612](https://issues.apache.org/jira/browse/LOG4J2-2612):
NullPointerException at org.apache.logging.log4j.core.appender.db.jdbc.JdbcDatabaseManager.writeInternal(JdbcDatabaseManager.java:803).
* [LOG4J2-2618](https://issues.apache.org/jira/browse/LOG4J2-2618):
Possible ClassCastException in org.apache.logging.log4j.core.script.ScriptManager.ScriptManager(Configuration, WatchManager)
* [LOG4J2-2631](https://issues.apache.org/jira/browse/LOG4J2-2631):
RoutingAppender PurgePolicy implementations no longer stop appenders referenced from the logger configuration,
        only those that have been created by the RoutingAppender. Note that RoutingAppender.getAppenders no longer
        includes entries for referenced appenders, only those which it has created.
* [LOG4J2-2629](https://issues.apache.org/jira/browse/LOG4J2-2629):
Fix a race allowing events not to be recorded when a RoutingAppender purge policy attempts to delete an idle
        appender at exactly the same time as a new event is recorded.
* [LOG4J2-2606](https://issues.apache.org/jira/browse/LOG4J2-2606):
Asynchronous logging when the queue is full no longer results in heavy CPU utilization and low throughput.

### Changes
* [](https://issues.apache.org/jira/browse/LOG4J2-2606):
Update tests from H2 1.4.197 to 1.4.199. Thanks to Gary Gregory.
* [LOG4J2-2570](https://issues.apache.org/jira/browse/LOG4J2-2570):
Update Jackson from 2.9.7 to 2.9.8. Thanks to Gary Gregory.
* [LOG4J2-2574](https://issues.apache.org/jira/browse/LOG4J2-2574):
Update MongoDB 3 module driver from 3.9.0 to 3.10.1. Thanks to Gary Gregory.
* [LOG4J2-2619](https://issues.apache.org/jira/browse/LOG4J2-2619):
Update Jackson from 2.9.8 to 2.9.9.
* [LOG4J2-2634](https://issues.apache.org/jira/browse/LOG4J2-2634):
Refactor several AsyncLogger methods below the 35 byte threshold for inlining.

---

Apache Log4j 2.12.0 requires a minimum of Java 7 to build and run. Log4j 2.3 was the
last release that supported Java 6.

Basic compatibility with Log4j 1.x is provided through the log4j-1.2-api component, however it
does not implement some of the very implementation specific classes and methods. The package
names and Maven groupId have been changed to org.apache.logging.log4j to avoid any conflicts
with log4j 1.x.

For complete information on Apache Log4j 2, including instructions on how to submit bug
reports, patches, or suggestions for improvement, see the Apache Apache Log4j 2 website:

https://logging.apache.org/log4j/2.x/