/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import org.apache.logging.log4j.core.util.Throwables;
import org.junit.Assert;
import org.junit.Test;

public class ThrowablesTest {
    @Test
    public void testGetRootCauseNone() throws Exception {
        NullPointerException throwable = new NullPointerException();
        Assert.assertEquals((Object)throwable, (Object)Throwables.getRootCause((Throwable)throwable));
    }

    @Test
    public void testGetRootCauseDepth1() throws Exception {
        NullPointerException throwable = new NullPointerException();
        Assert.assertEquals((Object)throwable, (Object)Throwables.getRootCause((Throwable)new UnsupportedOperationException(throwable)));
    }

    @Test
    public void testGetRootCauseDepth2() throws Exception {
        NullPointerException throwable = new NullPointerException();
        Assert.assertEquals((Object)throwable, (Object)Throwables.getRootCause((Throwable)new IllegalArgumentException(new UnsupportedOperationException(throwable))));
    }

    @Test(expected=NullPointerException.class)
    public void testRethrowRuntimeException() throws Exception {
        Throwables.rethrow((Throwable)new NullPointerException());
    }

    @Test(expected=UnknownError.class)
    public void testRethrowError() throws Exception {
        Throwables.rethrow((Throwable)new UnknownError());
    }

    @Test(expected=NoSuchMethodException.class)
    public void testRethrowCheckedException() throws Exception {
        Throwables.rethrow((Throwable)new NoSuchMethodException());
    }
}

