/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.File;
import java.net.URI;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.junit.Assert;
import org.junit.Test;

public class ConfiguratorTest {
    @Test
    public void testInitializeFromAbsoluteFilePath() {
        String path = new File("src/test/resources/log4j-list.xml").getAbsolutePath();
        this.testInitializeFromFilePath(path);
    }

    @Test
    public void testInitializeFromRelativeFilePath() {
        String path = new File("src/test/resources/log4j-list.xml").toString();
        this.testInitializeFromFilePath(path);
    }

    @Test
    public void testReconfigure() {
        String path = new File("src/test/resources/log4j-list.xml").getAbsolutePath();
        try (LoggerContext loggerContext = Configurator.initialize((String)this.getClass().getName(), null, (String)path);){
            Assert.assertNotNull((Object)loggerContext.getConfiguration().getAppender("List"));
            URI uri = loggerContext.getConfigLocation();
            Assert.assertNotNull((String)"No configuration location returned", (Object)uri);
            Configurator.reconfigure();
            Assert.assertEquals((String)"Unexpected configuration location returned", (Object)uri, (Object)loggerContext.getConfigLocation());
        }
    }

    @Test
    public void testReconfigureFromPath() {
        String path = new File("src/test/resources/log4j-list.xml").getAbsolutePath();
        try (LoggerContext loggerContext = Configurator.initialize((String)this.getClass().getName(), null, (String)path);){
            Assert.assertNotNull((Object)loggerContext.getConfiguration().getAppender("List"));
            URI uri = loggerContext.getConfigLocation();
            Assert.assertNotNull((String)"No configuration location returned", (Object)uri);
            URI location = new File("src/test/resources/log4j2-config.xml").toURI();
            Configurator.reconfigure((URI)location);
            Assert.assertEquals((String)"Unexpected configuration location returned", (Object)location, (Object)loggerContext.getConfigLocation());
        }
    }

    private void testInitializeFromFilePath(String path) {
        try (LoggerContext loggerContext = Configurator.initialize((String)this.getClass().getName(), null, (String)path);){
            Assert.assertNotNull((Object)loggerContext.getConfiguration().getAppender("List"));
        }
    }
}

