/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.CompositeTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public abstract class AbstractLog4j2_1100Test {
    @Rule
    public LoggerContextRule context = new LoggerContextRule(this.getConfigurationResource());

    protected abstract String getConfigurationResource();

    @Test
    public void test() {
        Configuration configuration = this.context.getConfiguration();
        Assert.assertNotNull((Object)configuration);
        RollingFileAppender appender = (RollingFileAppender)configuration.getAppender("File");
        Assert.assertNotNull((Object)appender);
        CompositeTriggeringPolicy compositeTriggeringPolicy = (CompositeTriggeringPolicy)appender.getTriggeringPolicy();
        Assert.assertNotNull((Object)compositeTriggeringPolicy);
        TriggeringPolicy[] triggeringPolicies = compositeTriggeringPolicy.getTriggeringPolicies();
        SizeBasedTriggeringPolicy sizeBasedTriggeringPolicy = null;
        TimeBasedTriggeringPolicy timeBasedTriggeringPolicy = null;
        for (TriggeringPolicy triggeringPolicy : triggeringPolicies) {
            if (triggeringPolicy instanceof TimeBasedTriggeringPolicy) {
                timeBasedTriggeringPolicy = (TimeBasedTriggeringPolicy)triggeringPolicy;
                Assert.assertEquals((long)7L, (long)timeBasedTriggeringPolicy.getInterval());
            }
            if (!(triggeringPolicy instanceof SizeBasedTriggeringPolicy)) continue;
            sizeBasedTriggeringPolicy = (SizeBasedTriggeringPolicy)triggeringPolicy;
            Assert.assertEquals((long)0x6400000L, (long)sizeBasedTriggeringPolicy.getMaxFileSize());
        }
        if (timeBasedTriggeringPolicy == null) {
            Assert.fail((String)"Missing TimeBasedTriggeringPolicy");
        }
        if (sizeBasedTriggeringPolicy == null) {
            Assert.fail((String)"Missing SizeBasedTriggeringPolicy");
        }
    }
}

