/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class AsyncLoggerUseAfterShutdownTest {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("Log4jContextSelector", AsyncLoggerContextSelector.class.getName());
        System.setProperty("log4j.configurationFile", "AsyncLoggerTest.xml");
    }

    @AfterClass
    public static void afterClass() {
        System.setProperty("Log4jContextSelector", "");
    }

    @Test
    public void testNoErrorIfLogAfterShutdown() throws Exception {
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        String msg = "Async logger msg";
        log.info("Async logger msg", (Throwable)new InternalError("this is not a real error"));
        CoreLoggerContexts.stopLoggerContext();
        ((AbstractLogger)log).logMessage("com.foo.Bar", Level.INFO, null, (Message)new SimpleMessage("msg"), null);
    }
}

