/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.apache.logging.log4j.core.impl.DefaultLogEventFactory;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;
import org.apache.logging.log4j.message.Message;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class AsyncLoggerConfigErrorOnFormat {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j2.is.webapp", "false");
        System.setProperty("log4j.configurationFile", "AsyncLoggerConfigErrorOnFormat.xml");
        System.setProperty("log4j2.logEventFactory", DefaultLogEventFactory.class.getName());
    }

    @AfterClass
    public static void afterClass() {
        System.clearProperty("log4j2.is.webapp");
        System.clearProperty("log4j2.logEventFactory");
    }

    @Test
    public void testError() throws Exception {
        File file = new File("target", "AsyncLoggerConfigErrorOnFormat.log");
        Assert.assertTrue((String)"Deleted old file before test", (!file.exists() || file.delete() ? 1 : 0) != 0);
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        log.info((Message)new ThrowsErrorOnFormatMessage());
        log.info("Second message");
        CoreLoggerContexts.stopLoggerContext(file);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line1 = reader.readLine();
        String line2 = reader.readLine();
        reader.close();
        file.delete();
        Assert.assertThat((Object)line1, (Matcher)Matchers.containsString((String)"Second message"));
        Assert.assertNull((String)"Expected only one line", (Object)line2);
    }

    @AsynchronouslyFormattable
    private static final class ThrowsErrorOnFormatMessage
    implements Message {
        private ThrowsErrorOnFormatMessage() {
        }

        public String getFormattedMessage() {
            throw new Error("getFormattedMessage invoked on " + Thread.currentThread().getName());
        }

        public String getFormat() {
            return null;
        }

        public Object[] getParameters() {
            return null;
        }

        public Throwable getThrowable() {
            return null;
        }
    }
}

