/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.hamcrest.Descriptors;
import org.apache.logging.log4j.hamcrest.FileMatchers;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingAppenderReconfigureTest {
    private static final String DIR = "target/rolling1";
    private static final String CONFIG = "log4j-rolling-reconfigure.xml";
    private static final File CONFIG_FILE = new File("target/test-classes/", "log4j-rolling-reconfigure.xml");
    public static LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-reconfigure.xml");
    @Rule
    public RuleChain chain = loggerContextRule.withCleanFoldersRule("target/rolling1");
    private Logger logger;

    @Before
    public void setUp() throws Exception {
        this.logger = loggerContextRule.getLogger(RollingAppenderReconfigureTest.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReconfigure() throws Exception {
        for (int i = 0; i < 500; ++i) {
            String message = "This is test message number " + i;
            this.logger.debug(message);
        }
        File dir = new File(DIR);
        Assert.assertTrue((String)"Directory not created", (boolean)dir.exists());
        File[] files = dir.listFiles();
        Assert.assertThat((Object)files, (Matcher)Matchers.hasItemInArray(Descriptors.that(FileMatchers.hasName(Descriptors.that(Matchers.endsWith((String)".current"))))));
        Assert.assertThat((Object)files, (Matcher)Matchers.hasItemInArray(Descriptors.that(FileMatchers.hasName(Descriptors.that(Matchers.endsWith((String)".rolled"))))));
        String originalXmlConfig = FileUtils.readFileToString((File)CONFIG_FILE, (String)"UTF-8");
        try {
            String updatedXmlConfig = originalXmlConfig.replace("target/rolling1/rollingtest.%i.rolled", "target/rolling1/rollingtest.%i.reconfigured");
            FileUtils.write((File)CONFIG_FILE, (CharSequence)updatedXmlConfig, (String)"UTF-8");
            loggerContextRule.getLoggerContext().reconfigure();
            for (int i = 0; i < 500; ++i) {
                String message = "This is test message number " + i;
                this.logger.debug(message);
            }
            File[] filesAfterReconfigured = dir.listFiles();
            Assert.assertThat((Object)filesAfterReconfigured, (Matcher)Matchers.hasItemInArray(Descriptors.that(FileMatchers.hasName(Descriptors.that(Matchers.endsWith((String)".reconfigured"))))));
            Assert.assertThat((Object)filesAfterReconfigured, (Matcher)Matchers.hasItemInArray(Descriptors.that(FileMatchers.hasName(Descriptors.that(Matchers.endsWith((String)".current"))))));
            Assert.assertThat((Object)filesAfterReconfigured, (Matcher)Matchers.hasItemInArray(Descriptors.that(FileMatchers.hasName(Descriptors.that(Matchers.endsWith((String)".rolled"))))));
        }
        finally {
            FileUtils.write((File)CONFIG_FILE, (CharSequence)originalXmlConfig, (String)"UTF-8");
        }
    }
}

