/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.flume.appender;

import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.flume.Event;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAliases;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.Rfc5424Layout;
import org.apache.logging.log4j.core.net.Facility;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.flume.appender.AbstractFlumeManager;
import org.apache.logging.log4j.flume.appender.Agent;
import org.apache.logging.log4j.flume.appender.FlumeAvroManager;
import org.apache.logging.log4j.flume.appender.FlumeEmbeddedManager;
import org.apache.logging.log4j.flume.appender.FlumeEvent;
import org.apache.logging.log4j.flume.appender.FlumeEventFactory;
import org.apache.logging.log4j.flume.appender.FlumePersistentManager;
import org.apache.logging.log4j.util.Timer;

@Plugin(name="Flume", category="Core", elementType="appender", printObject=true)
public final class FlumeAppender
extends AbstractAppender
implements FlumeEventFactory {
    private static final String[] EXCLUDED_PACKAGES = new String[]{"org.apache.flume", "org.apache.avro"};
    private static final int DEFAULT_MAX_DELAY = 60000;
    private static final int DEFAULT_LOCK_TIMEOUT_RETRY_COUNT = 5;
    private final AbstractFlumeManager manager;
    private final String mdcIncludes;
    private final String mdcExcludes;
    private final String mdcRequired;
    private final String eventPrefix;
    private final String mdcPrefix;
    private final boolean compressBody;
    private final FlumeEventFactory factory;
    private Timer timer = new Timer("FlumeEvent", 5000);
    private volatile long count = 0L;

    private FlumeAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, String includes, String excludes, String required, String mdcPrefix, String eventPrefix, boolean compress, FlumeEventFactory factory, Property[] properties, AbstractFlumeManager manager) {
        super(name, filter, layout, ignoreExceptions, properties);
        this.manager = manager;
        this.mdcIncludes = includes;
        this.mdcExcludes = excludes;
        this.mdcRequired = required;
        this.eventPrefix = eventPrefix;
        this.mdcPrefix = mdcPrefix;
        this.compressBody = compress;
        this.factory = factory == null ? this : factory;
    }

    public void append(LogEvent event) {
        String name = event.getLoggerName();
        if (name != null) {
            for (String pkg : EXCLUDED_PACKAGES) {
                if (!name.startsWith(pkg)) continue;
                return;
            }
        }
        this.timer.startOrResume();
        FlumeEvent flumeEvent = this.factory.createEvent(event, this.mdcIncludes, this.mdcExcludes, this.mdcRequired, this.mdcPrefix, this.eventPrefix, this.compressBody);
        flumeEvent.setBody(this.getLayout().toByteArray((LogEvent)flumeEvent));
        if (this.update()) {
            String msg = this.timer.stop();
            LOGGER.debug(msg);
        } else {
            this.timer.pause();
        }
        this.manager.send((Event)flumeEvent);
    }

    private synchronized boolean update() {
        if (++this.count == 5000L) {
            this.count = 0L;
            return true;
        }
        return false;
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        boolean stopped = super.stop(timeout, timeUnit, false);
        this.setStopped();
        return stopped &= this.manager.stop(timeout, timeUnit);
    }

    @Override
    public FlumeEvent createEvent(LogEvent event, String includes, String excludes, String required, String mdcPrefix, String eventPrefix, boolean compress) {
        return new FlumeEvent(event, this.mdcIncludes, this.mdcExcludes, this.mdcRequired, mdcPrefix, eventPrefix, this.compressBody);
    }

    @PluginFactory
    public static FlumeAppender createAppender(@PluginElement(value="Agents") Agent[] agents, @PluginElement(value="Properties") Property[] properties, @PluginAttribute(value="hosts") String hosts, @PluginAttribute(value="embedded") String embedded, @PluginAttribute(value="type") String type, @PluginAttribute(value="dataDir") String dataDir, @PluginAliases(value={"connectTimeout"}) @PluginAttribute(value="connectTimeoutMillis") String connectionTimeoutMillis, @PluginAliases(value={"requestTimeout"}) @PluginAttribute(value="requestTimeoutMillis") String requestTimeoutMillis, @PluginAttribute(value="agentRetries") String agentRetries, @PluginAliases(value={"maxDelay"}) @PluginAttribute(value="maxDelayMillis") String maxDelayMillis, @PluginAttribute(value="name") String name, @PluginAttribute(value="ignoreExceptions") String ignore, @PluginAttribute(value="mdcExcludes") String excludes, @PluginAttribute(value="mdcIncludes") String includes, @PluginAttribute(value="mdcRequired") String required, @PluginAttribute(value="mdcPrefix") String mdcPrefix, @PluginAttribute(value="eventPrefix") String eventPrefix, @PluginAttribute(value="compress") String compressBody, @PluginAttribute(value="batchSize") String batchSize, @PluginAttribute(value="lockTimeoutRetries") String lockTimeoutRetries, @PluginElement(value="FlumeEventFactory") FlumeEventFactory factory, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter) {
        AbstractFlumeManager manager;
        ManagerType managerType;
        boolean embed = embedded != null ? Boolean.parseBoolean(embedded) : (agents == null || agents.length == 0 || hosts == null || hosts.isEmpty()) && properties != null && properties.length > 0;
        boolean ignoreExceptions = Booleans.parseBoolean((String)ignore, (boolean)true);
        boolean compress = Booleans.parseBoolean((String)compressBody, (boolean)true);
        if (type != null) {
            if (embed && embedded != null) {
                try {
                    managerType = ManagerType.getType(type);
                    LOGGER.warn("Embedded and type attributes are mutually exclusive. Using type " + type);
                }
                catch (Exception ex) {
                    LOGGER.warn("Embedded and type attributes are mutually exclusive and type " + type + " is invalid.");
                    managerType = ManagerType.EMBEDDED;
                }
            } else {
                try {
                    managerType = ManagerType.getType(type);
                }
                catch (Exception ex) {
                    LOGGER.warn("Type " + type + " is invalid.");
                    managerType = ManagerType.EMBEDDED;
                }
            }
        } else {
            managerType = embed ? ManagerType.EMBEDDED : ManagerType.AVRO;
        }
        int batchCount = Integers.parseInt((String)batchSize, (int)1);
        int connectTimeoutMillis = Integers.parseInt((String)connectionTimeoutMillis, (int)0);
        int reqTimeoutMillis = Integers.parseInt((String)requestTimeoutMillis, (int)0);
        int retries = Integers.parseInt((String)agentRetries, (int)0);
        int lockTimeoutRetryCount = Integers.parseInt((String)lockTimeoutRetries, (int)5);
        int delayMillis = Integers.parseInt((String)maxDelayMillis, (int)60000);
        if (layout == null) {
            int enterpriseNumber = 18060;
            layout = Rfc5424Layout.createLayout((Facility)Facility.LOCAL0, null, (int)18060, (boolean)true, (String)"mdc", (String)mdcPrefix, (String)eventPrefix, (boolean)false, null, null, null, (String)excludes, (String)includes, (String)required, null, (boolean)false, null, null);
        }
        if (name == null) {
            LOGGER.error("No name provided for Appender");
            return null;
        }
        switch (managerType) {
            case EMBEDDED: {
                manager = FlumeEmbeddedManager.getManager(name, agents, properties, batchCount, dataDir);
                break;
            }
            case AVRO: {
                manager = FlumeAvroManager.getManager(name, FlumeAppender.getAgents(agents, hosts), batchCount, delayMillis, retries, connectTimeoutMillis, reqTimeoutMillis);
                break;
            }
            case PERSISTENT: {
                manager = FlumePersistentManager.getManager(name, FlumeAppender.getAgents(agents, hosts), properties, batchCount, retries, connectTimeoutMillis, reqTimeoutMillis, delayMillis, lockTimeoutRetryCount, dataDir);
                break;
            }
            default: {
                LOGGER.debug("No manager type specified. Defaulting to AVRO");
                manager = FlumeAvroManager.getManager(name, FlumeAppender.getAgents(agents, hosts), batchCount, delayMillis, retries, connectTimeoutMillis, reqTimeoutMillis);
            }
        }
        if (manager == null) {
            return null;
        }
        return new FlumeAppender(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions, includes, excludes, required, mdcPrefix, eventPrefix, compress, factory, Property.EMPTY_ARRAY, manager);
    }

    private static Agent[] getAgents(Agent[] agents, String hosts) {
        if (agents == null || agents.length == 0) {
            if (hosts != null && !hosts.isEmpty()) {
                LOGGER.debug("Parsing agents from hosts parameter");
                String[] hostports = hosts.split(",");
                agents = new Agent[hostports.length];
                for (int i = 0; i < hostports.length; ++i) {
                    String[] h = hostports[i].split(":");
                    agents[i] = Agent.createAgent(h[0], h.length > 1 ? h[1] : null);
                }
            } else {
                LOGGER.debug("No agents provided, using defaults");
                agents = new Agent[]{Agent.createAgent(null, null)};
            }
        }
        LOGGER.debug("Using agents {}", (Object[])agents);
        return agents;
    }

    private static enum ManagerType {
        AVRO,
        EMBEDDED,
        PERSISTENT;


        public static ManagerType getType(String type) {
            return ManagerType.valueOf(type.toUpperCase(Locale.US));
        }
    }
}

