/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test.appender;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.CompositeFilter;

public class InMemoryAppender
extends AbstractOutputStreamAppender<InMemoryManager> {
    public InMemoryAppender(String name, Layout<? extends Serializable> layout, CompositeFilter filters, boolean ignoreExceptions, boolean writeHeader) {
        super(name, layout, (Filter)filters, ignoreExceptions, true, Property.EMPTY_ARRAY, (OutputStreamManager)new InMemoryManager(name, layout, writeHeader));
    }

    public String toString() {
        return ((InMemoryManager)this.getManager()).toString();
    }

    static class InMemoryManager
    extends OutputStreamManager {
        public InMemoryManager(String name, Layout<? extends Serializable> layout, boolean writeHeader) {
            super((OutputStream)new ByteArrayOutputStream(), name, layout, writeHeader);
        }

        public String toString() {
            try {
                return this.getOutputStream().toString();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

