/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test;

import org.apache.logging.log4j.test.AvailablePortFinder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class AvailablePortSystemPropertyTestRule
implements TestRule {
    protected final String name;
    protected int port;

    public static AvailablePortSystemPropertyTestRule create(String name) {
        return new AvailablePortSystemPropertyTestRule(name);
    }

    protected AvailablePortSystemPropertyTestRule(String name) {
        this.name = name;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                String oldValue = System.getProperty(AvailablePortSystemPropertyTestRule.this.name);
                try {
                    AvailablePortSystemPropertyTestRule.this.port = AvailablePortFinder.getNextAvailable();
                    System.setProperty(AvailablePortSystemPropertyTestRule.this.name, Integer.toString(AvailablePortSystemPropertyTestRule.this.port));
                    base.evaluate();
                }
                finally {
                    if (oldValue != null) {
                        System.setProperty(AvailablePortSystemPropertyTestRule.this.name, oldValue);
                    }
                }
            }
        };
    }

    public String getName() {
        return this.name;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AvailablePortSystemPropertyRule [name=");
        builder.append(this.name);
        builder.append(", port=");
        builder.append(this.port);
        builder.append("]");
        return builder.toString();
    }
}

