/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.pattern.StyleConverter;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.apache.logging.log4j.util.Strings;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class StyleConverterTest {
    private static final String EXPECTED = "\u001b[1;31mERROR\u001b[m \u001b[1;36mLoggerTest\u001b[m o.a.l.l.c.p.StyleConverterTest org.apache.logging.log4j.core.pattern.StyleConverterTest" + Strings.LINE_SEPARATOR;
    @Rule
    public LoggerContextRule init = new LoggerContextRule("log4j-style.xml");
    private Logger logger;
    private ListAppender app;

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j.skipJansi", "false");
    }

    @Before
    public void setUp() throws Exception {
        this.logger = this.init.getLogger("LoggerTest");
        this.app = this.init.getListAppender("List").clear();
    }

    @Test
    public void testReplacement() {
        this.logger.error(this.getClass().getName());
        List<String> msgs = this.app.getMessages();
        Assert.assertNotNull(msgs);
        Assert.assertEquals((String)("Incorrect number of messages. Should be 1 is " + msgs.size()), (long)1L, (long)msgs.size());
        Assert.assertTrue((String)("Replacement failed - expected ending " + EXPECTED + ", actual " + msgs.get(0)), (boolean)msgs.get(0).endsWith(EXPECTED));
    }

    @Test
    public void testNull() {
        Assert.assertNull((Object)StyleConverter.newInstance(null, null));
    }
}

