/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.builder.impl.DefaultConfigurationBuilder;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.pattern.MessagePatternConverter;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.message.StringMapMessage;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.junit.Assert;
import org.junit.Test;

public class MessagePatternConverterTest {
    @Test
    public void testPattern() throws Exception {
        MessagePatternConverter converter = MessagePatternConverter.newInstance(null, null);
        SimpleMessage msg = new SimpleMessage("Hello!");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((String)"Unexpected result", (Object)"Hello!", (Object)sb.toString());
        event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage(null).build();
        sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((String)("Incorrect length: " + sb), (long)0L, (long)sb.length());
        msg = new SimpleMessage(null);
        event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((String)("Incorrect length: " + sb), (long)4L, (long)sb.length());
    }

    @Test
    public void testPatternAndParameterizedMessageDateLookup() throws Exception {
        MessagePatternConverter converter = MessagePatternConverter.newInstance(null, null);
        ParameterizedMessage msg = new ParameterizedMessage("${date:now:buhu}", new Object[0]);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((String)"Unexpected result", (Object)"${date:now:buhu}", (Object)sb.toString());
    }

    @Test
    public void testLookupEnabledByDefault() {
        Assert.assertFalse((String)"Expected lookups to be enabled", (boolean)Constants.FORMAT_MESSAGES_PATTERN_DISABLE_LOOKUPS);
    }

    @Test
    public void testLookup() {
        Configuration config = new DefaultConfigurationBuilder().addProperty("foo", "bar").build(true);
        MessagePatternConverter converter = MessagePatternConverter.newInstance((Configuration)config, null);
        ParameterizedMessage msg = new ParameterizedMessage("${foo}", new Object[0]);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((String)"Unexpected result", (Object)"bar", (Object)sb.toString());
    }

    @Test
    public void testDisabledLookup() {
        Configuration config = new DefaultConfigurationBuilder().addProperty("foo", "bar").build(true);
        MessagePatternConverter converter = MessagePatternConverter.newInstance((Configuration)config, (String[])new String[]{"nolookups"});
        ParameterizedMessage msg = new ParameterizedMessage("${foo}", new Object[0]);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((String)"Expected the raw pattern string without lookup", (Object)"${foo}", (Object)sb.toString());
    }

    @Test
    public void testPatternWithConfiguration() throws Exception {
        DefaultConfiguration config = new DefaultConfiguration();
        MessagePatternConverter converter = MessagePatternConverter.newInstance((Configuration)config, null);
        SimpleMessage msg = new SimpleMessage("Hello!");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((String)"Unexpected result", (Object)"Hello!", (Object)sb.toString());
        event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage(null).build();
        sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((String)("Incorrect length: " + sb), (long)0L, (long)sb.length());
        msg = new SimpleMessage(null);
        event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((String)("Incorrect length: " + sb), (long)4L, (long)sb.length());
    }

    @Test
    public void testMapMessageFormatJson() throws Exception {
        MessagePatternConverter converter = MessagePatternConverter.newInstance(null, (String[])new String[]{"json"});
        MapMessage msg = new StringMapMessage().with("key", "val");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((String)"Unexpected result", (Object)"{\"key\":\"val\"}", (Object)sb.toString());
    }

    @Test
    public void testMapMessageFormatXml() throws Exception {
        MessagePatternConverter converter = MessagePatternConverter.newInstance(null, (String[])new String[]{"xml"});
        MapMessage msg = new StringMapMessage().with("key", "val");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((String)"Unexpected result", (Object)"<Map>\n  <Entry key=\"key\">val</Entry>\n</Map>", (Object)sb.toString());
    }

    @Test
    public void testMapMessageFormatDefault() throws Exception {
        MessagePatternConverter converter = MessagePatternConverter.newInstance(null, null);
        MapMessage msg = new StringMapMessage().with("key", "val");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((String)"Unexpected result", (Object)"key=\"val\"", (Object)sb.toString());
    }

    @Test
    public void testStructuredDataFormatFull() throws Exception {
        MessagePatternConverter converter = MessagePatternConverter.newInstance(null, (String[])new String[]{"FULL"});
        MapMessage msg = new StructuredDataMessage("id", "message", "type").with("key", "val");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((String)"Unexpected result", (Object)"type [id key=\"val\"] message", (Object)sb.toString());
    }
}

