/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.pattern.AnsiEscape;
import org.apache.logging.log4j.core.pattern.HighlightConverter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.Assert;
import org.junit.Test;

public class HighlightConverterTest {
    @Test
    public void testAnsiEmpty() {
        String[] options = new String[]{"", "noConsoleNoAnsi=false, disableAnsi=false"};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.INFO).setLoggerName("a.b.c").setMessage((Message)new SimpleMessage("message in a bottle")).build();
        StringBuilder buffer = new StringBuilder();
        converter.format((LogEvent)event, buffer);
        Assert.assertEquals((Object)"", (Object)buffer.toString());
    }

    @Test
    public void testAnsiNonEmpty() {
        String[] options = new String[]{"%-5level: %msg", "noConsoleNoAnsi=false, disableAnsi=false"};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.INFO).setLoggerName("a.b.c").setMessage((Message)new SimpleMessage("message in a bottle")).build();
        StringBuilder buffer = new StringBuilder();
        converter.format((LogEvent)event, buffer);
        Assert.assertEquals((Object)"\u001b[32mINFO : message in a bottle\u001b[m", (Object)buffer.toString());
    }

    @Test
    public void testLevelNamesBad() {
        String colorName = "red";
        String[] options = new String[]{"%-5level: %msg", "noConsoleNoAnsi=false, disableAnsi=false, BAD_LEVEL_A=red, BAD_LEVEL_B=red"};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Assert.assertNotNull((Object)converter);
        Assert.assertNotNull((Object)converter.getLevelStyle(Level.TRACE));
        Assert.assertNotNull((Object)converter.getLevelStyle(Level.DEBUG));
    }

    @Test
    public void testLevelNamesGood() {
        String colorName = "red";
        String[] options = new String[]{"%-5level: %msg", "noConsoleNoAnsi=false, disableAnsi=false, DEBUG=red, TRACE=red"};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Assert.assertNotNull((Object)converter);
        Assert.assertEquals((Object)AnsiEscape.createSequence((String[])new String[]{"red"}), (Object)converter.getLevelStyle(Level.TRACE));
        Assert.assertEquals((Object)AnsiEscape.createSequence((String[])new String[]{"red"}), (Object)converter.getLevelStyle(Level.DEBUG));
    }

    @Test
    public void testLevelNamesUnknown() {
        String colorName = "blue";
        String[] options = new String[]{"%level", "noConsoleNoAnsi=false, disableAnsi=false, DEBUG=blue, CUSTOM1=blue"};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Assert.assertNotNull((Object)converter);
        Assert.assertNotNull((Object)converter.getLevelStyle(Level.INFO));
        Assert.assertNotNull((Object)converter.getLevelStyle(Level.DEBUG));
        Assert.assertNotNull((Object)converter.getLevelStyle(Level.forName((String)"CUSTOM1", (int)412)));
        Assert.assertNull((Object)converter.getLevelStyle(Level.forName((String)"CUSTOM2", (int)512)));
        Assert.assertArrayEquals((byte[])new byte[]{27, 91, 51, 52, 109, 68, 69, 66, 85, 71, 27, 91, 109}, (byte[])this.toFormattedCharSeq(converter, Level.DEBUG).toString().getBytes());
        Assert.assertArrayEquals((byte[])new byte[]{27, 91, 51, 50, 109, 73, 78, 70, 79, 27, 91, 109}, (byte[])this.toFormattedCharSeq(converter, Level.INFO).toString().getBytes());
        Assert.assertArrayEquals((byte[])new byte[]{27, 91, 51, 52, 109, 67, 85, 83, 84, 79, 77, 49, 27, 91, 109}, (byte[])this.toFormattedCharSeq(converter, Level.forName((String)"CUSTOM1", (int)412)).toString().getBytes());
        Assert.assertArrayEquals((byte[])new byte[]{67, 85, 83, 84, 79, 77, 50}, (byte[])this.toFormattedCharSeq(converter, Level.forName((String)"CUSTOM2", (int)512)).toString().getBytes());
    }

    @Test
    public void testLevelNamesNone() {
        String[] options = new String[]{"%-5level: %msg", "noConsoleNoAnsi=false, disableAnsi=false"};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Assert.assertNotNull((Object)converter);
        Assert.assertNotNull((Object)converter.getLevelStyle(Level.TRACE));
        Assert.assertNotNull((Object)converter.getLevelStyle(Level.DEBUG));
    }

    @Test
    public void testNoAnsiEmpty() {
        String[] options = new String[]{"", "disableAnsi=true"};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.INFO).setLoggerName("a.b.c").setMessage((Message)new SimpleMessage("message in a bottle")).build();
        StringBuilder buffer = new StringBuilder();
        converter.format((LogEvent)event, buffer);
        Assert.assertEquals((Object)"", (Object)buffer.toString());
    }

    @Test
    public void testNoAnsiNonEmpty() {
        String[] options = new String[]{"%-5level: %msg", "disableAnsi=true"};
        HighlightConverter converter = HighlightConverter.newInstance(null, (String[])options);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.INFO).setLoggerName("a.b.c").setMessage((Message)new SimpleMessage("message in a bottle")).build();
        StringBuilder buffer = new StringBuilder();
        converter.format((LogEvent)event, buffer);
        Assert.assertEquals((Object)"INFO : message in a bottle", (Object)buffer.toString());
    }

    private CharSequence toFormattedCharSeq(HighlightConverter converter, Level level) {
        StringBuilder sb = new StringBuilder();
        converter.format((LogEvent)Log4jLogEvent.newBuilder().setLevel(level).build(), sb);
        return sb;
    }
}

