/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.AvailablePortFinder;
import org.apache.logging.log4j.util.Strings;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Currently needs better port choosing support")
public class SocketReconnectTest {
    private static final int SOCKET_PORT = AvailablePortFinder.getNextAvailable();
    private static final String CONFIG = "log4j-socket.xml";
    private static final String SHUTDOWN = "Shutdown" + Strings.LINE_SEPARATOR + "................................................................" + Strings.LINE_SEPARATOR + "................................................................" + Strings.LINE_SEPARATOR + "................................................................" + Strings.LINE_SEPARATOR + "................................................................" + Strings.LINE_SEPARATOR;
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j-socket.xml");

    @Test
    public void testReconnect() throws Exception {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        TestSocketServer server = new TestSocketServer(list);
        server.start();
        Thread.sleep(300L);
        Logger logger = context.getLogger();
        String message = "Log #1";
        logger.error(message);
        String expectedHeader = "Header";
        String msg = null;
        String header = null;
        for (int i2 = 0; i2 < 5; ++i2) {
            Thread.sleep(100L);
            if (list.size() <= 1) continue;
            header = (String)list.get(0);
            msg = (String)list.get(1);
            break;
        }
        Assert.assertNotNull((String)"No header", header);
        Assert.assertEquals((Object)"Header", header);
        Assert.assertNotNull((String)"No message", msg);
        Assert.assertEquals((Object)message, msg);
        logger.error(SHUTDOWN);
        server.join();
        list.clear();
        message = "Log #2";
        boolean exceptionCaught = false;
        for (i = 0; i < 100; ++i) {
            try {
                logger.error(message);
                continue;
            }
            catch (AppenderLoggingException e) {
                exceptionCaught = true;
                break;
            }
        }
        Assert.assertTrue((String)"No Exception thrown", (boolean)exceptionCaught);
        message = "Log #3";
        server = new TestSocketServer(list);
        server.start();
        Thread.sleep(300L);
        msg = null;
        header = null;
        logger.error(message);
        for (i = 0; i < 5; ++i) {
            Thread.sleep(100L);
            if (list.size() <= 1) continue;
            header = (String)list.get(0);
            msg = (String)list.get(1);
            break;
        }
        Assert.assertNotNull((String)"No header", (Object)header);
        Assert.assertEquals((Object)"Header", (Object)header);
        Assert.assertNotNull((String)"No message", (Object)msg);
        Assert.assertEquals((Object)message, (Object)msg);
        logger.error(SHUTDOWN);
        server.join();
    }

    private static class TestSocketServer
    extends Thread {
        private volatile boolean shutdown = false;
        private final List<String> list;
        private Socket client;

        public TestSocketServer(List<String> list) {
            this.list = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ServerSocket server = null;
            this.client = null;
            try {
                server = new ServerSocket(SOCKET_PORT);
                this.client = server.accept();
                while (!this.shutdown) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
                    String line = reader.readLine();
                    if (line.equals("Shutdown")) {
                        this.shutdown = true;
                        continue;
                    }
                    this.list.add(line);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (this.client != null) {
                    try {
                        this.client.close();
                    }
                    catch (Exception ex) {
                        System.out.println("Unable to close socket " + ex.getMessage());
                    }
                }
                if (server != null) {
                    try {
                        server.close();
                    }
                    catch (Exception ex) {
                        System.out.println("Unable to close server socket " + ex.getMessage());
                    }
                }
            }
        }
    }
}

