/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.AvailablePortFinder;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Currently needs better port choosing support")
public class SocketMessageLossTest {
    private static final int SOCKET_PORT = AvailablePortFinder.getNextAvailable();
    private static final String CONFIG = "log4j-socket2.xml";
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j-socket2.xml");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSocket() throws Exception {
        ExecutorService executor = null;
        try {
            executor = Executors.newSingleThreadExecutor();
            System.err.println("Initializing server");
            TestSocketServer testServer = new TestSocketServer();
            Future<InputStream> futureIn = executor.submit(testServer);
            Logger logger = context.getLogger();
            String message = "Log #1";
            logger.error(message);
            BufferedReader reader = new BufferedReader(new InputStreamReader(futureIn.get()));
            Assert.assertEquals((Object)message, (Object)reader.readLine());
            SocketMessageLossTest.closeQuietly(testServer);
            Assert.assertTrue((String)"Server not shutdown", (boolean)testServer.server.isClosed());
            Thread.sleep(1000L);
            message = "Log #2";
            try {
                logger.error(message);
                Assert.fail((String)"Expected exception not thrown");
            }
            catch (AppenderLoggingException appenderLoggingException) {
                // empty catch block
            }
            message = "Log #3";
            try {
                logger.error(message);
                Assert.fail((String)"Expected exception not thrown");
            }
            catch (AppenderLoggingException appenderLoggingException) {
                // empty catch block
            }
        }
        finally {
            SocketMessageLossTest.closeQuietly(executor);
        }
    }

    private static void closeQuietly(ExecutorService executor) {
        if (null != executor) {
            executor.shutdownNow();
        }
    }

    private static void closeQuietly(TestSocketServer testServer) {
        if (null != testServer) {
            testServer.close();
        }
    }

    static /* synthetic */ int access$100() {
        return SOCKET_PORT;
    }

    private static class TestSocketServer
    implements Callable<InputStream> {
        private final ServerSocket server = new ServerSocket(SocketMessageLossTest.access$100());
        private Socket client;

        @Override
        public InputStream call() throws Exception {
            this.client = this.server.accept();
            return this.client.getInputStream();
        }

        public void close() {
            TestSocketServer.closeQuietly(this.client);
            TestSocketServer.closeQuietly(this.server);
        }

        private static void closeQuietly(ServerSocket socket) {
            if (null != socket) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private static void closeQuietly(Socket socket) {
            if (null != socket) {
                try {
                    socket.setSoLinger(true, 0);
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

