/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.categories.Layouts;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.BasicConfigurationFactory;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.jackson.Log4jXmlObjectMapper;
import org.apache.logging.log4j.core.layout.LogEventFixtures;
import org.apache.logging.log4j.core.layout.XmlLayout;
import org.apache.logging.log4j.core.lookup.JavaLookup;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.junit.ThreadContextRule;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Layouts.Xml.class})
public class XmlLayoutTest {
    private static final String body = "<Message>empty mdc</Message>";
    static ConfigurationFactory cf = new BasicConfigurationFactory();
    private static final String markerTag = "<Marker name=\"EVENT\"/>";
    @Rule
    public final ThreadContextRule threadContextRule = new ThreadContextRule();
    LoggerContext ctx = LoggerContext.getContext();
    Logger rootLogger = this.ctx.getRootLogger();

    @AfterClass
    public static void cleanupClass() {
        ConfigurationFactory.removeConfigurationFactory((ConfigurationFactory)cf);
    }

    @BeforeClass
    public static void setupClass() {
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)cf);
        LoggerContext ctx = LoggerContext.getContext();
        ctx.reconfigure();
    }

    private void checkAttribute(String name, String value, boolean compact, String str) {
        Assert.assertTrue((String)str, (boolean)str.contains(name + "=\"" + value + "\""));
    }

    private void checkAttributeName(String name, boolean compact, String str) {
        Assert.assertTrue((String)str, (boolean)str.contains(name + "=\""));
    }

    private void checkContains(String expected, List<String> list) {
        for (String string : list) {
            String trimedLine = string.trim();
            if (!trimedLine.contains(expected)) continue;
            return;
        }
        Assert.fail((String)("Cannot find " + expected + " in " + list));
    }

    private void checkElement(String key, String value, boolean compact, String str) {
        Assert.assertTrue((String)str, (boolean)str.contains(String.format("<item key=\"%s\" value=\"%s\"/>", key, value)));
    }

    private void checkElementName(String name, boolean compact, String str, boolean withAttributes, boolean withChildren) {
        String startStr = withAttributes ? "<" + name + " " : "<" + name + ">";
        int startPos = str.indexOf(startStr);
        Assert.assertTrue((String)str, (startPos >= 0 ? 1 : 0) != 0);
        String endStr = withChildren ? "</" + name + ">" : "/>";
        int endPos = str.indexOf(endStr, startPos + startStr.length());
        Assert.assertTrue((String)str, (endPos >= 0 ? 1 : 0) != 0);
    }

    private void checkElementNameAbsent(String name, boolean compact, String str) {
        Assert.assertFalse((boolean)str.contains("<" + name));
    }

    private void testAllFeatures(boolean includeSource, boolean compact, boolean includeContext, boolean includeStacktrace) throws IOException, JsonParseException, JsonMappingException {
        Log4jLogEvent expected = LogEventFixtures.createLogEvent();
        XmlLayout layout = ((XmlLayout.Builder)((XmlLayout.Builder)((XmlLayout.Builder)((XmlLayout.Builder)((XmlLayout.Builder)((XmlLayout.Builder)XmlLayout.newBuilder().setLocationInfo(includeSource)).setProperties(includeContext)).setComplete(false)).setCompact(compact)).setIncludeStacktrace(includeStacktrace)).setCharset(StandardCharsets.UTF_8)).build();
        String str = layout.toSerializable((LogEvent)expected);
        Assert.assertEquals((String)str, (Object)(!compact ? 1 : 0), (Object)str.contains("\n"));
        Assert.assertEquals((String)str, (Object)includeSource, (Object)str.contains("Source"));
        Assert.assertEquals((String)str, (Object)includeContext, (Object)str.contains("ContextMap"));
        Log4jLogEvent actual = (Log4jLogEvent)new Log4jXmlObjectMapper().readValue(str, Log4jLogEvent.class);
        LogEventFixtures.assertEqualLogEvents((LogEvent)expected, (LogEvent)actual, includeSource, includeContext, includeStacktrace);
        if (includeContext) {
            this.checkElement("MDC.A", "A_Value", compact, str);
            this.checkElement("MDC.B", "B_Value", compact, str);
        }
        Assert.assertNull((Object)actual.getThrown());
        Assert.assertTrue((String)str, (boolean)str.contains("loggerFqcn=\"f.q.c.n\""));
        Assert.assertTrue((String)str, (boolean)str.contains("loggerName=\"a.B\""));
        Assert.assertTrue((String)str, (boolean)str.contains("<Event "));
        if (includeStacktrace) {
            Assert.assertTrue((String)str, (boolean)str.contains("class="));
            Assert.assertTrue((String)str, (boolean)str.contains("method="));
            Assert.assertTrue((String)str, (boolean)str.contains("file="));
            Assert.assertTrue((String)str, (boolean)str.contains("line="));
        }
        this.checkElementName("Instant", compact, str, true, false);
        this.checkAttributeName("epochSecond", compact, str);
        this.checkAttributeName("nanoOfSecond", compact, str);
        this.checkAttributeName("thread", compact, str);
        this.checkAttributeName("level", compact, str);
        this.checkAttributeName("loggerName", compact, str);
        this.checkElementName("Marker", compact, str, true, true);
        this.checkAttributeName("name", compact, str);
        this.checkElementName("Parents", compact, str, false, true);
        this.checkElementName("Message", compact, str, false, true);
        this.checkElementName("Thrown", compact, str, true, true);
        this.checkElementName("Cause", compact, str, true, includeStacktrace);
        this.checkAttributeName("commonElementCount", compact, str);
        this.checkAttributeName("message", compact, str);
        this.checkAttributeName("localizedMessage", compact, str);
        if (includeStacktrace) {
            this.checkElementName("ExtendedStackTrace", compact, str, false, true);
            this.checkAttributeName("class", compact, str);
            this.checkAttributeName("method", compact, str);
            this.checkAttributeName("file", compact, str);
            this.checkAttributeName("line", compact, str);
            this.checkAttributeName("exact", compact, str);
            this.checkAttributeName("location", compact, str);
            this.checkAttributeName("version", compact, str);
        } else {
            this.checkElementNameAbsent("ExtendedStackTrace", compact, str);
        }
        this.checkElementName("Suppressed", compact, str, false, true);
        this.checkAttributeName("loggerFqcn", compact, str);
        this.checkAttributeName("endOfBatch", compact, str);
        if (includeContext) {
            this.checkElementName("ContextMap", compact, str, false, true);
        } else {
            this.checkElementNameAbsent("ContextMap", compact, str);
        }
        this.checkElementName("ContextStack", compact, str, false, true);
        if (includeSource) {
            this.checkElementName("Source", compact, str, true, false);
        } else {
            this.checkElementNameAbsent("Source", compact, str);
        }
        this.checkAttribute("loggerFqcn", "f.q.c.n", compact, str);
        this.checkAttribute("loggerName", "a.B", compact, str);
    }

    @Test
    public void testContentType() {
        XmlLayout layout = XmlLayout.createDefaultLayout();
        Assert.assertEquals((Object)"text/xml; charset=UTF-8", (Object)layout.getContentType());
    }

    @Test
    public void testDefaultCharset() {
        XmlLayout layout = XmlLayout.createDefaultLayout();
        Assert.assertEquals((Object)StandardCharsets.UTF_8, (Object)layout.getCharset());
    }

    @Test
    public void testLayout() throws Exception {
        Object appender2;
        Map appenders = this.rootLogger.getAppenders();
        for (Object appender2 : appenders.values()) {
            this.rootLogger.removeAppender((Appender)appender2);
        }
        XmlLayout layout = ((XmlLayout.Builder)((XmlLayout.Builder)((XmlLayout.Builder)((XmlLayout.Builder)((XmlLayout.Builder)XmlLayout.newBuilder().setLocationInfo(true)).setProperties(true)).setComplete(true)).setCompact(false)).setIncludeStacktrace(true)).build();
        appender2 = new ListAppender("List", null, (Layout<? extends Serializable>)layout, true, false);
        appender2.start();
        this.rootLogger.addAppender((Appender)appender2);
        this.rootLogger.setLevel(Level.DEBUG);
        this.rootLogger.debug("starting mdc pattern test");
        this.rootLogger.debug("empty mdc");
        ThreadContext.put((String)"key1", (String)"value1");
        ThreadContext.put((String)"key2", (String)"value2");
        this.rootLogger.debug("filled mdc");
        ThreadContext.remove((String)"key1");
        ThreadContext.remove((String)"key2");
        this.rootLogger.error("finished mdc pattern test", (Throwable)new NullPointerException("test"));
        Marker marker = MarkerManager.getMarker((String)"EVENT");
        this.rootLogger.error(marker, "marker test");
        appender2.stop();
        List<String> list = ((ListAppender)((Object)appender2)).getMessages();
        String string = list.get(0);
        Assert.assertTrue((String)("Incorrect header: " + string), (boolean)string.equals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
        Assert.assertTrue((String)"Incorrect footer", (boolean)list.get(list.size() - 1).equals("</Events>"));
        this.checkContains("loggerFqcn=\"" + AbstractLogger.class.getName() + "\"", list);
        this.checkContains("level=\"DEBUG\"", list);
        this.checkContains(">starting mdc pattern test</Message>", list);
        this.checkContains("<Marker", list);
        this.checkContains("name=\"EVENT\"/>", list);
        for (Appender app : appenders.values()) {
            this.rootLogger.addAppender(app);
        }
    }

    @Test
    public void testLayoutLoggerName() {
        XmlLayout layout = ((XmlLayout.Builder)((XmlLayout.Builder)((XmlLayout.Builder)((XmlLayout.Builder)((XmlLayout.Builder)XmlLayout.newBuilder().setLocationInfo(false)).setProperties(true)).setComplete(true)).setCompact(false)).setIncludeStacktrace(true)).build();
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("a.B").setLoggerFqcn("f.q.c.n").setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("M")).setThreadName("threadName").setTimeMillis(1L).build();
        String str = layout.toSerializable((LogEvent)event);
        Assert.assertTrue((String)str, (boolean)str.contains("loggerName=\"a.B\""));
    }

    @Test
    public void testAdditionalFields() throws Exception {
        XmlLayout layout = ((XmlLayout.Builder)((XmlLayout.Builder)((XmlLayout.Builder)((XmlLayout.Builder)((XmlLayout.Builder)((XmlLayout.Builder)XmlLayout.newBuilder().setLocationInfo(false)).setProperties(false)).setIncludeStacktrace(false)).setAdditionalFields(new KeyValuePair[]{new KeyValuePair("KEY1", "VALUE1"), new KeyValuePair("KEY2", "${java:runtime}")})).setCharset(StandardCharsets.UTF_8)).setConfiguration(this.ctx.getConfiguration())).build();
        String str = layout.toSerializable((LogEvent)LogEventFixtures.createLogEvent());
        Assert.assertTrue((String)str, (boolean)str.contains("<KEY1>VALUE1</KEY1>"));
        Assert.assertTrue((String)str, (boolean)str.contains("<KEY2>" + new JavaLookup().getRuntime() + "</KEY2>"));
    }

    @Test
    public void testLocationOffCompactOffMdcOff() throws Exception {
        this.testAllFeatures(false, false, false, true);
    }

    @Test
    public void testLocationOnCompactOnMdcOn() throws Exception {
        this.testAllFeatures(true, true, true, true);
    }

    @Test
    public void testExcludeStacktrace() throws Exception {
        this.testAllFeatures(false, false, false, false);
    }

    @Test
    public void testStacktraceAsString() throws Exception {
        String str = this.prepareXMLForStacktraceTests(true);
        Assert.assertTrue((String)str, (boolean)str.contains("<ExtendedStackTrace>java.lang.NullPointerException"));
    }

    @Test
    public void testStacktraceAsNonString() throws Exception {
        String str = this.prepareXMLForStacktraceTests(false);
        Assert.assertTrue((String)str, (boolean)str.contains("<ExtendedStackTrace><ExtendedStackTraceItem"));
    }

    private String prepareXMLForStacktraceTests(boolean stacktraceAsString) {
        Log4jLogEvent expected = LogEventFixtures.createLogEvent();
        XmlLayout layout = ((XmlLayout.Builder)((XmlLayout.Builder)((XmlLayout.Builder)XmlLayout.newBuilder().setCompact(true)).setIncludeStacktrace(true)).setStacktraceAsString(stacktraceAsString)).build();
        return layout.toSerializable((LogEvent)expected);
    }

    @Test
    public void testIncludeNullDelimiterTrue() throws Exception {
        XmlLayout layout = ((XmlLayout.Builder)((XmlLayout.Builder)XmlLayout.newBuilder().setCompact(true)).setIncludeNullDelimiter(true)).build();
        String str = layout.toSerializable((LogEvent)LogEventFixtures.createLogEvent());
        Assert.assertTrue((boolean)str.endsWith("\u0000"));
    }

    @Test
    public void testIncludeNullDelimiterFalse() throws Exception {
        XmlLayout layout = ((XmlLayout.Builder)((XmlLayout.Builder)XmlLayout.newBuilder().setCompact(true)).setIncludeNullDelimiter(false)).build();
        String str = layout.toSerializable((LogEvent)LogEventFixtures.createLogEvent());
        Assert.assertFalse((boolean)str.endsWith("\u0000"));
    }
}

