/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVFormat;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.categories.Layouts;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.layout.AbstractCsvLayout;
import org.apache.logging.log4j.core.layout.CsvParameterLayout;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.junit.ThreadContextRule;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ObjectArrayMessage;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={Layouts.Csv.class})
public class CsvParameterLayoutTest {
    @Rule
    public final LoggerContextRule init;
    @Rule
    public final ThreadContextRule threadContextRule = new ThreadContextRule();

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({new LoggerContextRule("csvParamsSync.xml")}, {new LoggerContextRule("csvParamsMixedAsync.xml")});
    }

    public CsvParameterLayoutTest(LoggerContextRule contextRule) {
        this.init = contextRule;
    }

    @Test
    public void testCustomCharset() {
        AbstractCsvLayout layout = CsvParameterLayout.createLayout(null, (String)"Excel", null, null, null, null, null, null, (Charset)StandardCharsets.UTF_16, null, null);
        Assert.assertEquals((Object)"text/csv; charset=UTF-16", (Object)layout.getContentType());
    }

    @Test
    public void testDefaultCharset() {
        AbstractCsvLayout layout = CsvParameterLayout.createDefaultLayout();
        Assert.assertEquals((Object)StandardCharsets.UTF_8, (Object)layout.getCharset());
    }

    @Test
    public void testDefaultContentType() {
        AbstractCsvLayout layout = CsvParameterLayout.createDefaultLayout();
        Assert.assertEquals((Object)"text/csv; charset=UTF-8", (Object)layout.getContentType());
    }

    static void testLayoutNormalApi(Logger root, AbstractCsvLayout layout, boolean messageApi) throws Exception {
        CsvParameterLayoutTest.removeAppenders(root);
        ListAppender appender = new ListAppender("List", null, (Layout<? extends Serializable>)layout, true, false);
        appender.start();
        appender.countDownLatch = new CountDownLatch(4);
        root.addAppender((Appender)appender);
        root.setLevel(Level.DEBUG);
        if (messageApi) {
            CsvParameterLayoutTest.logDebugObjectArrayMessage(root);
        } else {
            CsvParameterLayoutTest.logDebugNormalApi(root);
        }
        int msgCount = 4;
        if (appender.getMessages().size() < 4) {
            appender.countDownLatch.await(10L, TimeUnit.SECONDS);
        }
        Assert.assertEquals((String)"Background thread did not finish processing: msg count", (long)4L, (long)appender.getMessages().size());
        appender.stop();
        List<String> list = appender.getMessages();
        char d = layout.getFormat().getDelimiter();
        Assert.assertEquals((Object)("1" + d + "2" + d + "3"), (Object)list.get(0));
        Assert.assertEquals((Object)("2" + d + "3"), (Object)list.get(1));
        Assert.assertEquals((Object)("5" + d + "6"), (Object)list.get(2));
        Assert.assertEquals((Object)("7" + d + "8" + d + "9" + d + "10"), (Object)list.get(3));
    }

    private static void removeAppenders(Logger root) {
        Map appenders = root.getAppenders();
        for (Appender appender : appenders.values()) {
            root.removeAppender(appender);
        }
    }

    private static void logDebugNormalApi(Logger root) {
        root.debug("with placeholders: {}{}{}", (Object)1, (Object)2, (Object)3);
        root.debug("without placeholders", (Object)2, (Object)3);
        root.debug(null, (Object)5, (Object)6);
        root.debug("invalid placeholder count {}", (Object)7, (Object)8, (Object)9, (Object)10);
    }

    private static void logDebugObjectArrayMessage(Logger root) {
        root.debug((Message)new ObjectArrayMessage(new Object[]{1, 2, 3}));
        root.debug((Message)new ObjectArrayMessage(new Object[]{2, 3}));
        root.debug((Message)new ObjectArrayMessage(new Object[]{5, 6}));
        root.debug((Message)new ObjectArrayMessage(new Object[]{7, 8, 9, 10}));
    }

    @Test
    public void testLayoutDefaultNormal() throws Exception {
        Logger root = this.init.getRootLogger();
        CsvParameterLayoutTest.testLayoutNormalApi(root, CsvParameterLayout.createDefaultLayout(), false);
    }

    @Test
    public void testLayoutDefaultObjectArrayMessage() throws Exception {
        Logger root = this.init.getRootLogger();
        CsvParameterLayoutTest.testLayoutNormalApi(root, CsvParameterLayout.createDefaultLayout(), true);
    }

    @Test
    public void testLayoutTab() throws Exception {
        Logger root = this.init.getRootLogger();
        CsvParameterLayoutTest.testLayoutNormalApi(root, CsvParameterLayout.createLayout((CSVFormat)CSVFormat.TDF), true);
    }

    @Test
    public void testLogJsonArgument() throws InterruptedException {
        ListAppender appender = (ListAppender)((Object)this.init.getAppender("List"));
        appender.countDownLatch = new CountDownLatch(4);
        appender.clear();
        Logger logger = (Logger)LogManager.getRootLogger();
        String json = "{\"id\":10,\"name\":\"Alice\"}";
        logger.error("log:{}", (Object)"{\"id\":10,\"name\":\"Alice\"}");
        boolean msgCount = true;
        if (appender.getMessages().size() < 1) {
            appender.countDownLatch.await(5L, TimeUnit.SECONDS);
        }
        Assert.assertEquals((String)"Background thread did not finish processing: msg count", (long)1L, (long)appender.getMessages().size());
        appender.stop();
        List<String> list = appender.getMessages();
        String eventStr = list.get(0).toString();
        Assert.assertTrue((String)eventStr, (boolean)eventStr.contains("{\"id\":10,\"name\":\"Alice\"}"));
    }
}

