/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.ThreadContextTest;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.impl.ContextDataInjectorFactory;
import org.apache.logging.log4j.spi.ReadOnlyThreadContextMap;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ThreadContextDataInjectorTest {
    @Parameterized.Parameter
    public String threadContextMapClassName;
    @Parameterized.Parameter(value=1)
    public String readOnlythreadContextMapClassName;

    @Parameterized.Parameters(name="{0}")
    public static Collection<String[]> threadContextMapClassNames() {
        return Arrays.asList({"org.apache.logging.log4j.spi.CopyOnWriteSortedArrayThreadContextMap", "org.apache.logging.log4j.spi.CopyOnWriteSortedArrayThreadContextMap"}, {"org.apache.logging.log4j.spi.GarbageFreeSortedArrayThreadContextMap", "org.apache.logging.log4j.spi.GarbageFreeSortedArrayThreadContextMap"}, {"org.apache.logging.log4j.spi.DefaultThreadContextMap", null});
    }

    @Before
    public void before() {
        System.setProperty("log4j2.threadContextMap", this.threadContextMapClassName);
    }

    @After
    public void after() {
        ThreadContext.remove((String)"foo");
        ThreadContext.remove((String)"baz");
        System.clearProperty("log4j2.threadContextMap");
        System.clearProperty("log4j2.isThreadContextMapInheritable");
    }

    private void testContextDataInjector() {
        ReadOnlyThreadContextMap readOnlythreadContextMap = ThreadContext.getThreadContextMap();
        MatcherAssert.assertThat((String)"thread context map class name", (Object)(readOnlythreadContextMap == null ? null : readOnlythreadContextMap.getClass().getName()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.readOnlythreadContextMapClassName)));
        ContextDataInjector contextDataInjector = ContextDataInjectorFactory.createInjector();
        StringMap stringMap = contextDataInjector.injectContextData(null, (StringMap)new SortedArrayStringMap());
        MatcherAssert.assertThat((String)"thread context map", (Object)ThreadContext.getContext(), (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"foo", (Object)"bar"), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"baz"))));
        MatcherAssert.assertThat((String)"context map", (Object)stringMap.toMap(), (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"foo", (Object)"bar"), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"baz"))));
        if (!stringMap.isFrozen()) {
            stringMap.clear();
            MatcherAssert.assertThat((String)"thread context map", (Object)ThreadContext.getContext(), (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"foo", (Object)"bar"), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"baz"))));
            MatcherAssert.assertThat((String)"context map", stringMap.toMap().entrySet(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        }
        ThreadContext.put((String)"foo", (String)"bum");
        ThreadContext.put((String)"baz", (String)"bam");
        MatcherAssert.assertThat((String)"thread context map", (Object)ThreadContext.getContext(), (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"foo", (Object)"bum"), (Matcher)Matchers.hasEntry((Object)"baz", (Object)"bam")));
        if (stringMap.isFrozen()) {
            MatcherAssert.assertThat((String)"context map", (Object)stringMap.toMap(), (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"foo", (Object)"bar"), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"baz"))));
        } else {
            MatcherAssert.assertThat((String)"context map", stringMap.toMap().entrySet(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        }
    }

    private void prepareThreadContext(boolean isThreadContextMapInheritable) {
        System.setProperty("log4j2.isThreadContextMapInheritable", Boolean.toString(isThreadContextMapInheritable));
        PropertiesUtil.getProperties().reload();
        ThreadContextTest.reinitThreadContext();
        ThreadContext.remove((String)"baz");
        ThreadContext.put((String)"foo", (String)"bar");
    }

    @Test
    public void testThreadContextImmutability() {
        this.prepareThreadContext(false);
        this.testContextDataInjector();
    }

    @Test
    public void testInheritableThreadContextImmutability() throws Throwable {
        this.prepareThreadContext(true);
        try {
            Executors.newSingleThreadExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    ThreadContextDataInjectorTest.this.testContextDataInjector();
                }
            }).get();
        }
        catch (ExecutionException ee) {
            throw ee.getCause();
        }
    }
}

