/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.StructuredDataFilter;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class StructuredDataFilterTest {
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j2-sdfilter.xml");

    @Test
    public void testFilter() {
        KeyValuePair[] pairs = new KeyValuePair[]{new KeyValuePair("id.name", "AccountTransfer"), new KeyValuePair("ToAccount", "123456")};
        StructuredDataFilter filter = StructuredDataFilter.createFilter((KeyValuePair[])pairs, (String)"and", null, null);
        filter.start();
        StructuredDataMessage msg = new StructuredDataMessage("AccountTransfer@18060", "Transfer Successful", "Audit");
        msg.put("ToAccount", "123456");
        msg.put("FromAccount", "211000");
        msg.put("Amount", "1000.00");
        Assert.assertTrue((boolean)filter.isStarted());
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.DEBUG, null, (Message)msg, null));
        msg.put("ToAccount", "111111");
        Assert.assertSame((Object)Filter.Result.DENY, (Object)filter.filter(null, Level.ERROR, null, (Message)msg, null));
        filter = StructuredDataFilter.createFilter((KeyValuePair[])pairs, (String)"or", null, null);
        filter.start();
        msg = new StructuredDataMessage("AccountTransfer@18060", "Transfer Successful", "Audit");
        msg.put("ToAccount", "123456");
        msg.put("FromAccount", "211000");
        msg.put("Amount", "1000.00");
        Assert.assertTrue((boolean)filter.isStarted());
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.DEBUG, null, (Message)msg, null));
        msg.put("ToAccount", "111111");
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.ERROR, null, (Message)msg, null));
    }

    @Test
    public void testConfig() {
        Configuration config = context.getConfiguration();
        Filter filter = config.getFilter();
        Assert.assertNotNull((String)"No StructuredDataFilter", (Object)filter);
        Assert.assertTrue((String)"Not a StructuredDataFilter", (boolean)(filter instanceof StructuredDataFilter));
        StructuredDataFilter sdFilter = (StructuredDataFilter)filter;
        Assert.assertFalse((String)"Should not be And filter", (boolean)sdFilter.isAnd());
        Map map = sdFilter.getMap();
        Assert.assertNotNull((String)"No Map", (Object)map);
        Assert.assertFalse((String)"No elements in Map", (boolean)map.isEmpty());
        Assert.assertEquals((String)"Incorrect number of elements in Map", (long)1L, (long)map.size());
        Assert.assertTrue((String)"Map does not contain key eventId", (boolean)map.containsKey("eventId"));
        Assert.assertEquals((String)"List does not contain 2 elements", (long)2L, (long)((List)map.get("eventId")).size());
    }
}

