/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.filter.BurstFilter;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class BurstFilterTest {
    private static final String CONFIG = "log4j-burst.xml";
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j-burst.xml");
    private ListAppender app;
    private BurstFilter filter;
    private final Logger logger = context.getLogger();

    @Before
    public void setUp() throws Exception {
        this.app = context.getListAppender("ListAppender");
        this.filter = (BurstFilter)this.app.getFilter();
        Assert.assertNotNull((String)"No BurstFilter", (Object)this.filter);
    }

    @Test
    public void test() throws Exception {
        int i;
        System.nanoTime();
        for (int i2 = 0; i2 < 110; ++i2) {
            if (i2 % 10 == 0) {
                Thread.sleep(200L);
            }
            this.logger.info("Logging 110 messages, should only see 100 logs # " + (i2 + 1));
            Assert.assertTrue((String)"Incorrect number of available slots", (this.filter.getAvailable() < 100 ? 1 : 0) != 0);
        }
        List<String> msgs = this.app.getMessages();
        Assert.assertEquals((String)("Incorrect message count. Should be 100, actual " + msgs.size()), (long)100L, (long)msgs.size());
        this.app.clear();
        Assert.assertTrue((String)"Incorrect number of available slots", (this.filter.getAvailable() < 100 ? 1 : 0) != 0);
        Thread.sleep(1500L);
        for (i = 0; i < 110; ++i) {
            this.logger.info("Waited 1.5 seconds and trying to log again, should see more than 0 and less than 100" + (i + 1));
        }
        msgs = this.app.getMessages();
        Assert.assertFalse((String)"No messages were counted.", (boolean)msgs.isEmpty());
        Assert.assertTrue((String)("Incorrect message count. Should be > 0 and < 100, actual " + msgs.size()), (msgs.size() < 100 ? 1 : 0) != 0);
        this.app.clear();
        this.filter.clear();
        for (i = 0; i < 110; ++i) {
            this.logger.info("Waited 1.5 seconds and trying to log again, should see more than 0 and less than 100" + (i + 1));
        }
        Assert.assertEquals((String)"", (long)0L, (long)this.filter.getAvailable());
        this.app.clear();
        for (i = 0; i < 110; ++i) {
            this.logger.debug("TEST FAILED! Logging 110 debug messages, shouldn't see any of them because they are debugs #" + (i + 1));
        }
        msgs = this.app.getMessages();
        Assert.assertTrue((String)("Incorrect message count. Should be 0, actual " + msgs.size()), (boolean)msgs.isEmpty());
        this.app.clear();
        for (i = 0; i < 110; ++i) {
            this.logger.warn("Logging 110 warn messages, should see all of them because they are warns #" + (i + 1));
        }
        msgs = this.app.getMessages();
        Assert.assertEquals((String)("Incorrect message count. Should be 110, actual " + msgs.size()), (long)110L, (long)msgs.size());
        this.app.clear();
        for (i = 0; i < 110; ++i) {
            this.logger.error("Logging 110 error messages, should see all of them because they are errors #" + (i + 1));
        }
        msgs = this.app.getMessages();
        Assert.assertEquals((String)("Incorrect message count. Should be 110, actual " + msgs.size()), (long)110L, (long)msgs.size());
        this.app.clear();
        for (i = 0; i < 110; ++i) {
            this.logger.fatal("Logging 110 fatal messages, should see all of them because they are fatals #" + (i + 1));
        }
        msgs = this.app.getMessages();
        Assert.assertEquals((String)("Incorrect message count. Should be 110, actual " + msgs.size()), (long)110L, (long)msgs.size());
        this.app.clear();
        Thread.sleep(3100L);
        for (i = 0; i < 110; ++i) {
            this.logger.debug("Waited 3+ seconds, should see 100 logs #" + (i + 1));
        }
        msgs = this.app.getMessages();
        Assert.assertEquals((String)("Incorrect message count. Should be 100, actual " + msgs.size()), (long)100L, (long)msgs.size());
        this.app.clear();
    }
}

