/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import org.apache.logging.log4j.core.config.plugins.util.PluginManagerPackagesTest;
import org.apache.logging.log4j.core.config.plugins.util.PluginRegistry;
import org.apache.logging.log4j.core.config.plugins.util.ResolverUtil;
import org.apache.logging.log4j.junit.CleanFolders;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ResolverUtilTest {
    static final String WORK_DIR = "target/testpluginsutil";
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)new CleanFolders("target/testpluginsutil"));

    @Test
    public void testExtractPathFromJarUrl() throws Exception {
        URL url = new URL("jar:file:/C:/Users/me/.m2/repository/junit/junit/4.11/junit-4.11.jar!/org/junit/Test.class");
        String expected = "/C:/Users/me/.m2/repository/junit/junit/4.11/junit-4.11.jar";
        Assert.assertEquals((Object)"/C:/Users/me/.m2/repository/junit/junit/4.11/junit-4.11.jar", (Object)new ResolverUtil().extractPath(url));
    }

    @Test
    public void testExtractPathFromJarUrlNotDecodedIfFileExists() throws Exception {
        this.testExtractPathFromJarUrlNotDecodedIfFileExists("/log4j+config+with+plus+characters.xml");
    }

    private void testExtractPathFromJarUrlNotDecodedIfFileExists(String existingFile) throws MalformedURLException, UnsupportedEncodingException, URISyntaxException {
        URL url = ResolverUtilTest.class.getResource(existingFile);
        if (!url.getProtocol().equals("jar")) {
            url = new URL("jar:" + url.toExternalForm() + "!/some/entry");
        }
        String actual = new ResolverUtil().extractPath(url);
        Assert.assertTrue((String)("should not be decoded: " + actual), (boolean)actual.endsWith(existingFile));
    }

    @Test
    public void testFileFromUriWithSpacesAndPlusCharactersInName() throws Exception {
        String existingFile = "/s p a c e s/log4j+config+with+plus+characters.xml";
        this.testExtractPathFromJarUrlNotDecodedIfFileExists("/s p a c e s/log4j+config+with+plus+characters.xml");
    }

    @Test
    public void testExtractPathFromJarUrlDecodedIfFileDoesNotExist() throws Exception {
        URL url = new URL("jar:file:/path+with+plus/file+does+not+exist.jar!/some/file");
        String expected = "/path with plus/file does not exist.jar";
        Assert.assertEquals((Object)"/path with plus/file does not exist.jar", (Object)new ResolverUtil().extractPath(url));
    }

    @Test
    public void testExtractPathFromFileUrl() throws Exception {
        URL url = new URL("file:/C:/Users/me/workspace/log4j2/log4j-core/target/test-classes/log4j2-config.xml");
        String expected = "/C:/Users/me/workspace/log4j2/log4j-core/target/test-classes/log4j2-config.xml";
        Assert.assertEquals((Object)"/C:/Users/me/workspace/log4j2/log4j-core/target/test-classes/log4j2-config.xml", (Object)new ResolverUtil().extractPath(url));
    }

    @Test
    public void testExtractPathFromFileUrlNotDecodedIfFileExists() throws Exception {
        String existingFile = "/log4j+config+with+plus+characters.xml";
        URL url = ResolverUtilTest.class.getResource("/log4j+config+with+plus+characters.xml");
        Assert.assertTrue((String)("should be file url but was " + url), (boolean)"file".equals(url.getProtocol()));
        String actual = new ResolverUtil().extractPath(url);
        Assert.assertTrue((String)("should not be decoded: " + actual), (boolean)actual.endsWith("/log4j+config+with+plus+characters.xml"));
    }

    @Test
    public void testExtractPathFromFileUrlDecodedIfFileDoesNotExist() throws Exception {
        URL url = new URL("file:///path+with+plus/file+does+not+exist.xml");
        String expected = "/path with plus/file does not exist.xml";
        Assert.assertEquals((Object)"/path with plus/file does not exist.xml", (Object)new ResolverUtil().extractPath(url));
    }

    @Test
    public void testExtractPathFromHttpUrl() throws Exception {
        URL url = new URL("http://java.sun.com/index.html#chapter1");
        String expected = "/index.html";
        Assert.assertEquals((Object)"/index.html", (Object)new ResolverUtil().extractPath(url));
    }

    @Test
    public void testExtractPathFromHttpUrlWithPlusCharacters() throws Exception {
        URL url = new URL("http://www.server.com/path+with+plus/file+name+with+plus.jar!/org/junit/Test.class");
        String expected = "/path with plus/file name with plus.jar";
        Assert.assertEquals((Object)"/path with plus/file name with plus.jar", (Object)new ResolverUtil().extractPath(url));
    }

    @Test
    public void testExtractPathFromHttpsComplexUrl() throws Exception {
        URL url = new URL("https://issues.apache.org/jira/browse/LOG4J2-445?focusedCommentId=13862479&page=com.atlassian.jira.plugin.system.issuetabpanels:comment-tabpanel#comment-13862479");
        String expected = "/jira/browse/LOG4J2-445";
        Assert.assertEquals((Object)"/jira/browse/LOG4J2-445", (Object)new ResolverUtil().extractPath(url));
    }

    @Test
    public void testExtractPathFromFtpUrl() throws Exception {
        URL url = new URL("ftp://user001:secretpassword@private.ftp-servers.example.com/mydirectory/myfile.txt");
        String expected = "/mydirectory/myfile.txt";
        Assert.assertEquals((Object)"/mydirectory/myfile.txt", (Object)new ResolverUtil().extractPath(url));
    }

    @Test
    public void testExtractPathFromFtpUrlWithPlusCharacters() throws Exception {
        URL url = new URL("ftp://user001:secretpassword@private.ftp-servers.example.com/my+directory/my+file.txt");
        String expected = "/my directory/my file.txt";
        Assert.assertEquals((Object)"/my directory/my file.txt", (Object)new ResolverUtil().extractPath(url));
    }

    @Test
    public void testFindInPackageFromDirectoryPath() throws Exception {
        try (URLClassLoader cl = ResolverUtilTest.compileAndCreateClassLoader("1");){
            ResolverUtil resolverUtil = new ResolverUtil();
            resolverUtil.setClassLoader((ClassLoader)cl);
            resolverUtil.findInPackage((ResolverUtil.Test)new PluginRegistry.PluginTest(), "customplugin1");
            Assert.assertEquals((String)"Class not found in packages", (long)1L, (long)resolverUtil.getClasses().size());
            Assert.assertEquals((String)"Unexpected class resolved", cl.loadClass("customplugin1.FixedString1Layout"), resolverUtil.getClasses().iterator().next());
        }
    }

    @Test
    public void testFindInPackageFromJarPath() throws Exception {
        try (URLClassLoader cl = ResolverUtilTest.compileJarAndCreateClassLoader("2");){
            ResolverUtil resolverUtil = new ResolverUtil();
            resolverUtil.setClassLoader((ClassLoader)cl);
            resolverUtil.findInPackage((ResolverUtil.Test)new PluginRegistry.PluginTest(), "customplugin2");
            Assert.assertEquals((String)"Class not found in packages", (long)1L, (long)resolverUtil.getClasses().size());
            Assert.assertEquals((String)"Unexpected class resolved", cl.loadClass("customplugin2.FixedString2Layout"), resolverUtil.getClasses().iterator().next());
        }
    }

    static URLClassLoader compileJarAndCreateClassLoader(String suffix) throws IOException, Exception {
        File workDir = ResolverUtilTest.compile(suffix);
        File jarFile = new File(workDir, "customplugin" + suffix + ".jar");
        URI jarURI = jarFile.toURI();
        ResolverUtilTest.createJar(jarURI, workDir, new File(workDir, "customplugin" + suffix + "/FixedString" + suffix + "Layout.class"));
        return URLClassLoader.newInstance(new URL[]{jarURI.toURL()});
    }

    static URLClassLoader compileAndCreateClassLoader(String suffix) throws IOException {
        File workDir = ResolverUtilTest.compile(suffix);
        return URLClassLoader.newInstance(new URL[]{workDir.toURI().toURL()});
    }

    static File compile(String suffix) throws IOException {
        File orig = new File("target/test-classes/customplugin/FixedStringLayout.java.source");
        File workDir = new File(WORK_DIR, "resolverutil" + suffix);
        File f = new File(workDir, "customplugin" + suffix + "/FixedString" + suffix + "Layout.java");
        File parent = f.getParentFile();
        if (!parent.exists()) {
            Assert.assertTrue((String)("Create customplugin" + suffix + " folder KO"), (boolean)f.getParentFile().mkdirs());
        }
        String content = new String(Files.readAllBytes(orig.toPath())).replaceAll("FixedString", "FixedString" + suffix).replaceAll("customplugin", "customplugin" + suffix);
        Files.write(f.toPath(), content.getBytes(), new OpenOption[0]);
        PluginManagerPackagesTest.compile(f);
        return workDir;
    }

    static void createJar(URI jarURI, File workDir, File f) throws Exception {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        URI uri = URI.create("jar:file://" + jarURI.getRawPath());
        try (FileSystem zipfs = FileSystems.newFileSystem(uri, env);){
            Path path = zipfs.getPath(workDir.toPath().relativize(f.toPath()).toString(), new String[0]);
            if (path.getParent() != null) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            Files.copy(f.toPath(), path, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

