/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.convert;

import org.apache.logging.log4j.core.config.plugins.convert.TypeConverter;
import org.apache.logging.log4j.core.config.plugins.convert.TypeConverterRegistry;
import org.apache.logging.log4j.core.config.plugins.convert.TypeConverters;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TypeConverterRegistryTest {
    @Test(expected=NullPointerException.class)
    public void testFindNullConverter() throws Exception {
        TypeConverterRegistry.getInstance().findCompatibleConverter(null);
    }

    @Test
    public void testFindBooleanConverter() throws Exception {
        TypeConverter converter = TypeConverterRegistry.getInstance().findCompatibleConverter(Boolean.class);
        Assert.assertNotNull((Object)converter);
        Assert.assertTrue((boolean)((Boolean)converter.convert("TRUE")));
    }

    @Test
    public void testFindPrimitiveBooleanConverter() throws Exception {
        TypeConverter converter = TypeConverterRegistry.getInstance().findCompatibleConverter(Boolean.TYPE);
        Assert.assertNotNull((Object)converter);
        Assert.assertTrue((boolean)((Boolean)converter.convert("tRUe")));
    }

    @Test
    public void testFindCharSequenceConverterUsingStringConverter() throws Exception {
        TypeConverter converter = TypeConverterRegistry.getInstance().findCompatibleConverter(CharSequence.class);
        Assert.assertNotNull((Object)converter);
        Assert.assertThat((Object)converter, (Matcher)Matchers.instanceOf(TypeConverters.StringConverter.class));
        String expected = "This is a test sequence of characters";
        CharSequence actual = (CharSequence)converter.convert(expected.toString());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFindNumberConverter() throws Exception {
        TypeConverter numberTypeConverter = TypeConverterRegistry.getInstance().findCompatibleConverter(Number.class);
        Assert.assertNotNull((Object)numberTypeConverter);
    }

    @Test
    public void testFindEnumConverter() throws Exception {
        TypeConverter fooTypeConverter = TypeConverterRegistry.getInstance().findCompatibleConverter(Foo.class);
        Assert.assertNotNull((Object)fooTypeConverter);
        Assert.assertEquals((Object)((Object)Foo.I), (Object)fooTypeConverter.convert("i"));
        Assert.assertEquals((Object)((Object)Foo.PITY), (Object)fooTypeConverter.convert("pity"));
        Assert.assertEquals((Object)((Object)Foo.THE), (Object)fooTypeConverter.convert("THE"));
    }

    public static enum Foo {
        I,
        PITY,
        THE;

    }
}

