/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.convert;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.logging.log4j.core.config.plugins.convert.DateTypeConverter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DateTypeConverterTest {
    private final Class<? extends Date> dateClass;
    private final long timestamp;
    private final Object expected;

    @Parameterized.Parameters
    public static Object[][] data() {
        long millis = System.currentTimeMillis();
        return new Object[][]{{Date.class, millis, new Date(millis)}, {java.sql.Date.class, millis, new java.sql.Date(millis)}, {Time.class, millis, new Time(millis)}, {Timestamp.class, millis, new Timestamp(millis)}};
    }

    public DateTypeConverterTest(Class<? extends Date> dateClass, long timestamp, Object expected) {
        this.dateClass = dateClass;
        this.timestamp = timestamp;
        this.expected = expected;
    }

    @Test
    public void testFromMillis() throws Exception {
        Assert.assertEquals((Object)this.expected, (Object)DateTypeConverter.fromMillis((long)this.timestamp, this.dateClass));
    }
}

