/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.HashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.AppenderControlArraySet;
import org.apache.logging.log4j.test.appender.FailOnceAppender;
import org.junit.Assert;
import org.junit.Test;

public class AppenderControlArraySetTest {
    @Test
    public void testInitiallyEmpty() throws Exception {
        Assert.assertTrue((boolean)new AppenderControlArraySet().isEmpty());
        Assert.assertTrue((new AppenderControlArraySet().get().length == 0 ? 1 : 0) != 0);
    }

    private AppenderControl createControl(String name) {
        FailOnceAppender appender = FailOnceAppender.createAppender(name);
        return new AppenderControl((Appender)appender, Level.INFO, null);
    }

    @Test
    public void testAddMakesNonEmpty() throws Exception {
        AppenderControlArraySet set = new AppenderControlArraySet();
        Assert.assertTrue((boolean)set.isEmpty());
        set.add(this.createControl("A"));
        Assert.assertFalse((boolean)set.isEmpty());
    }

    @Test
    public void testAddReturnsTrueIfSuccessfullyAdded() throws Exception {
        AppenderControlArraySet set = new AppenderControlArraySet();
        Assert.assertTrue((boolean)set.add(this.createControl("A")));
        Assert.assertTrue((boolean)set.add(this.createControl("B")));
        Assert.assertTrue((boolean)set.add(this.createControl("C")));
    }

    @Test
    public void testAddDoesNotAppendersWithSameName() throws Exception {
        AppenderControl[] controls;
        AppenderControlArraySet set = new AppenderControlArraySet();
        for (AppenderControl ctl : controls = new AppenderControl[]{this.createControl("A"), this.createControl("B"), this.createControl("B"), this.createControl("B"), this.createControl("A")}) {
            set.add(ctl);
        }
        Assert.assertEquals((long)2L, (long)set.get().length);
        Assert.assertSame((Object)controls[0], (Object)set.get()[0]);
        Assert.assertSame((Object)controls[1], (Object)set.get()[1]);
    }

    @Test
    public void testAddReturnsFalseIfAlreadyInSet() throws Exception {
        AppenderControlArraySet set = new AppenderControlArraySet();
        Assert.assertTrue((boolean)set.add(this.createControl("A")));
        Assert.assertTrue((boolean)set.add(this.createControl("B")));
        Assert.assertFalse((boolean)set.add(this.createControl("B")));
        Assert.assertFalse((boolean)set.add(this.createControl("B")));
        Assert.assertFalse((boolean)set.add(this.createControl("A")));
        Assert.assertEquals((long)2L, (long)set.get().length);
    }

    @Test
    public void testRemoveRemovesItemFromSet() throws Exception {
        AppenderControlArraySet set = new AppenderControlArraySet();
        set.add(this.createControl("A"));
        set.add(this.createControl("B"));
        set.add(this.createControl("C"));
        set.add(this.createControl("D"));
        Assert.assertEquals((long)4L, (long)set.get().length);
        set.remove("B");
        Assert.assertEquals((long)3L, (long)set.get().length);
        AppenderControl[] three = set.get();
        Assert.assertEquals((Object)"A", (Object)three[0].getAppenderName());
        Assert.assertEquals((Object)"C", (Object)three[1].getAppenderName());
        Assert.assertEquals((Object)"D", (Object)three[2].getAppenderName());
        set.remove("C");
        Assert.assertEquals((long)2L, (long)set.get().length);
        AppenderControl[] two = set.get();
        Assert.assertEquals((Object)"A", (Object)two[0].getAppenderName());
        Assert.assertEquals((Object)"D", (Object)two[1].getAppenderName());
        set.remove("A");
        Assert.assertEquals((long)1L, (long)set.get().length);
        AppenderControl[] one = set.get();
        Assert.assertEquals((Object)"D", (Object)one[0].getAppenderName());
        set.remove("D");
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testRemoveReturnsRemovedItem() throws Exception {
        AppenderControl[] controls;
        AppenderControlArraySet set = new AppenderControlArraySet();
        for (AppenderControl ctl : controls = new AppenderControl[]{this.createControl("A"), this.createControl("B"), this.createControl("C"), this.createControl("D")}) {
            set.add(ctl);
        }
        Assert.assertEquals((long)controls.length, (long)set.get().length);
        AppenderControl b = set.remove("B");
        Assert.assertSame((Object)controls[1], (Object)b);
        AppenderControl c = set.remove("C");
        Assert.assertSame((Object)controls[2], (Object)c);
    }

    @Test
    public void testAsMap() throws Exception {
        AppenderControl[] controls;
        AppenderControlArraySet set = new AppenderControlArraySet();
        for (AppenderControl ctl : controls = new AppenderControl[]{this.createControl("A"), this.createControl("B"), this.createControl("C"), this.createControl("D")}) {
            set.add(ctl);
        }
        HashMap<String, Appender> expected = new HashMap<String, Appender>();
        for (AppenderControl ctl : controls) {
            expected.put(ctl.getAppenderName(), ctl.getAppender());
        }
        Assert.assertEquals(expected, (Object)set.asMap());
    }

    @Test
    public void testClearRemovesAllItems() throws Exception {
        AppenderControlArraySet set = new AppenderControlArraySet();
        set.add(this.createControl("A"));
        set.add(this.createControl("B"));
        set.add(this.createControl("C"));
        Assert.assertFalse((boolean)set.isEmpty());
        set.clear();
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testClearReturnsAllItems() throws Exception {
        Object[] controls;
        AppenderControlArraySet set = new AppenderControlArraySet();
        for (AppenderControl appenderControl : controls = new AppenderControl[]{this.createControl("A"), this.createControl("B"), this.createControl("C")}) {
            set.add(appenderControl);
        }
        Assert.assertEquals((long)3L, (long)set.get().length);
        Object[] previous = set.clear();
        Assert.assertArrayEquals((Object[])previous, (Object[])controls);
    }

    @Test
    public void testIsEmptyMeansZeroLengthArray() throws Exception {
        AppenderControlArraySet set = new AppenderControlArraySet();
        Assert.assertTrue((boolean)set.isEmpty());
        Assert.assertTrue((set.get().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetReturnsAddedItems() throws Exception {
        Object[] controls;
        AppenderControlArraySet set = new AppenderControlArraySet();
        for (AppenderControl appenderControl : controls = new AppenderControl[]{this.createControl("A"), this.createControl("B"), this.createControl("C")}) {
            set.add(appenderControl);
        }
        Assert.assertEquals((long)3L, (long)set.get().length);
        Assert.assertArrayEquals((Object[])controls, (Object[])set.get());
    }
}

